/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.mvel;

import com.ds.jds.core.esb.mvel.JDSMapVariableResolver;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.CompileException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;

public class JDSEsbVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, ? extends Object> variables = new HashMap<String, Object>();
    private boolean cachingSafe = false;

    public JDSEsbVariableResolverFactory(Map<String, ? extends Object> variables) {
        this.variables = variables;
    }

    public JDSEsbVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        this.variables = variables;
        this.nextFactory = nextFactory;
    }

    public JDSEsbVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        this.variables = variables;
        this.cachingSafe = cachingSafe;
    }

    public VariableResolver createVariable(String name, Object value) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr != null) {
            vr.setValue(value);
            return vr;
        }
        vr = new JDSMapVariableResolver(this.variables, name, this.cachingSafe);
        vr.setValue(value);
        return vr;
    }

    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr != null && vr.getType() != null) {
            throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name, null, 0);
        }
        vr = new JDSMapVariableResolver(this.variables, name, type, this.cachingSafe);
        this.addResolver(name, vr);
        vr.setValue(value);
        return vr;
    }

    public VariableResolver getVariableResolver(String name) {
        if (this.variables.containsKey(name)) {
            return this.variableResolvers != null && this.variableResolvers.containsKey(name) ? (VariableResolver)this.variableResolvers.get(name) : new JDSMapVariableResolver(this.variables, name, this.cachingSafe);
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        return null;
    }

    public boolean isResolveable(String name) {
        if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
            return true;
        }
        if (this.variables != null && this.variables.containsKey(name)) {
            return true;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.isResolveable(name);
        }
        return false;
    }

    private void addResolver(String name, VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
    }

    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    public Set<String> getKnownVariables() {
        LinkedHashSet<String> knownVars = new LinkedHashSet<String>();
        if (this.nextFactory == null) {
            if (this.variables != null) {
                knownVars.addAll(this.variables.keySet());
            }
            return knownVars;
        }
        if (this.variables != null) {
            knownVars.addAll(this.variables.keySet());
        }
        knownVars.addAll(this.nextFactory.getKnownVariables());
        return knownVars;
    }
}

