/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.mvel;

import com.ds.common.util.ClassUtility;
import com.ds.esb.config.manager.JDSExpressionParserManager;
import com.ds.jds.core.esb.mvel.JDSClassVariableResolver;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

public class JDSClassVariableResolverFactory
extends BaseVariableResolverFactory {
    public JDSClassVariableResolverFactory() {
        this.variableResolvers = new HashMap();
    }

    public JDSClassVariableResolverFactory(VariableResolverFactory nextFactory) {
        Map classes = JDSExpressionParserManager.getExpressionTypeMap();
        this.nextFactory = nextFactory;
        this.variableResolvers = new HashMap();
        for (String s : classes.keySet()) {
            this.variableResolvers.put(s, new JDSClassVariableResolver(s, (Class)classes.get(s)));
        }
    }

    public VariableResolver getVariableResolver(String name) {
        try {
            Class clazz = ClassUtility.loadClass(name);
            return (VariableResolver)this.variableResolvers.get(clazz.getSimpleName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            if (this.isResolveable(name)) {
                if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
                    return (VariableResolver)this.variableResolvers.get(name);
                }
                if (this.nextFactory != null) {
                    return this.nextFactory.getVariableResolver(name);
                }
            }
            return null;
        }
    }

    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public Class addClass(Class clazz) {
        this.variableResolvers.put(JDSClassVariableResolverFactory.getSimpleClassName(clazz), new SimpleValueResolver((Object)clazz));
        return clazz;
    }

    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    public boolean isResolveable(String name) {
        return true;
    }

    public void clear() {
        this.variableResolvers.clear();
    }

    public void setImportedClasses(Map<String, Class> imports) {
        if (imports == null) {
            return;
        }
        for (String var : imports.keySet()) {
            this.variableResolvers.put(var, new SimpleValueResolver((Object)imports.get(var)));
        }
    }

    public Map<String, Object> getImportedClasses() {
        HashMap<String, Object> imports = new HashMap<String, Object>();
        for (String var : this.variableResolvers.keySet()) {
            imports.put(var, ((VariableResolver)this.variableResolvers.get(var)).getValue());
        }
        return imports;
    }

    public static String getSimpleClassName(Class cls) {
        return cls.getSimpleName();
    }
}

