/*
 * Decompiled with CFR 0.152.
 */
package com.ds.hsql;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.org.conf.OrgConstants;
import java.sql.Connection;
import java.sql.DriverManager;
import org.hsqldb.Server;

public class HsqlDbServer {
    private static final Log logger = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), HsqlDbServer.class);
    private String path;
    private final String dbName;
    private Integer port = 10523;
    private String serverProps;
    private String url;
    private String user;
    private String password;
    private boolean logEnabled;
    private Server server;

    public HsqlDbServer(String url, String user, String password, String path, String dbName, Integer port, boolean logEnabled) {
        this.url = url;
        this.user = user;
        this.password = password;
        if (port != null) {
            this.port = port;
        }
        this.path = path;
        this.dbName = dbName;
        if (this.serverProps != null) {
            this.serverProps = this.serverProps;
        }
        this.logEnabled = logEnabled;
    }

    public void startup() {
        this.server = new Server();
        this.server.setDatabaseName(0, this.dbName);
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
        this.server.setDatabasePath(0, this.path + this.dbName);
        this.server.setSilent(true);
        this.server.setPort(this.port.intValue());
        this.server.start();
    }

    public void shutdown() {
        this.server.stop();
        this.server = null;
    }

    public Connection newConnection() {
        try {
            return DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }
}

