/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.expression;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import com.ds.common.util.StringUtility;
import com.ds.esb.config.manager.JDSExpressionParserManager;
import java.lang.reflect.Constructor;
import java.util.Stack;

public class DefaultFunction
extends Function {
    private Constructor constructor;
    private String expressStr;
    private Class clazz;

    public DefaultFunction(Class clazz, Object[] objs) {
        Class[] types = new Class[objs.length];
        this.clazz = clazz;
        this.numberOfParameters = objs.length;
        boolean isNull = false;
        for (int f = 0; objs.length > f; ++f) {
            if (objs[f] != null) {
                types[f] = objs[f].getClass();
                continue;
            }
            isNull = true;
            types[f] = null;
        }
        if (isNull) {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            boolean isType = true;
            for (int k = 0; k < constructors.length; ++k) {
                Constructor<?> constructor = constructors[k];
                if (constructor.getParameterTypes().length != this.numberOfParameters) continue;
                for (int f = 0; objs.length > f; ++f) {
                    Class<?> type = constructor.getParameterTypes()[f];
                    if (objs[f] == null || type.isAssignableFrom(objs[f].getClass())) continue;
                    isType = false;
                }
                if (!isType) continue;
                this.constructor = constructor;
                return;
            }
        } else {
            try {
                this.constructor = clazz.getConstructor(types);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public DefaultFunction(Class clazz, String expressStr) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        this.clazz = clazz;
        if (constructors.length < 2 || expressStr == null) {
            this.constructor = constructors[0];
            this.numberOfParameters = constructors[0].getParameterTypes().length;
        } else {
            this.numberOfParameters = StringUtility.split(expressStr, ",").length - 1;
            for (int k = 0; k < constructors.length; ++k) {
                Constructor<?> constructor = constructors[k];
                if (constructor.getParameterTypes().length != this.numberOfParameters) continue;
                this.constructor = constructor;
            }
        }
    }

    @Override
    public void run(Stack stack) throws ParseException {
        if (this.constructor == null) {
            throw new ParseException("[" + this.getClass().getName() + "]\u6ca1\u6709[" + this.expressStr + "]\u65b9\u6cd5");
        }
        this.checkStack(stack);
        Object[] objs = new Object[this.numberOfParameters];
        for (int k = objs.length; k > 0; --k) {
            objs[k - 1] = stack.pop();
        }
        try {
            Object obj = JDSExpressionParserManager.invacationExpression(this.clazz, this.constructor, objs);
            stack.push(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException(e);
        }
    }
}

