/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.xml;

import com.ds.common.JDSException;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.formula.FormulaParams;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ExpressionParameter;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ExpressionTempParamBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import com.ds.esb.config.xml.ServiceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTempXmlProxy
implements ServiceConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionTempXmlProxy.class);
    private static final String strParams = "params";
    private static final String templetid = "templetid";
    private static final String templetdesc = "templetdesc";
    private static final String templetname = "templetname";
    private static final String expressionArr = "expressionArr";
    private static final String templet = "templet";
    private static final String code = "paramcode";
    private static final String clazz = "class";
    private static final String mainClass = "mainclass";
    private static final String name = "paramname";
    private static final String type = "paramtype";
    private static final String username = "username";
    private static final String password = "password";
    private static final String desc = "paramdesc";
    private static final String paramid = "paramid";
    private static final String returntype = "returntype";
    private static final String flowType = "flowtype";
    private static final String dataType = "datatype";
    private static final String tokenType = "tokenType";
    private static final String serverUrl = "serverUrl";
    private static final String filter = "filter";
    private static final String jspurl = "jspurl";
    private ServiceConfig serviceConfig;
    private EsbBean esbBean;

    public ExpressionTempXmlProxy(EsbBean esbBean) {
        this.esbBean = esbBean;
    }

    public String getPath() {
        return this.esbBean.getPath();
    }

    @Override
    public Set<Class<?>> init() {
        try {
            this.serviceConfig = ServiceConfig.getServiceConfig(this.esbBean.getPath());
        }
        catch (JDSException e) {
            e.printStackTrace();
            logger.error("esb load error: name=" + this.esbBean.getCnname() == null ? this.esbBean.getDesc() : this.esbBean.getCnname() + "[" + this.esbBean.getId() + "] path=" + this.esbBean.getPath());
        }
        return null;
    }

    @Override
    public ExpressionTempBean getServiceConfigById(String id) {
        String str = "templet." + id;
        ExpressionTempBean expressionTempBean = new ExpressionTempBean();
        expressionTempBean.setId(id);
        expressionTempBean.setDesc(this.serviceConfig.getValue(str + "." + templetdesc));
        expressionTempBean.setMainClass(this.serviceConfig.getValue(str + "." + mainClass));
        expressionTempBean.setName(this.serviceConfig.getValue(str + "." + templetname));
        expressionTempBean.setExpressionArr(this.serviceConfig.getValue(str + "." + expressionArr));
        expressionTempBean.setJspUrl(this.serviceConfig.getValue(str + "." + jspurl));
        expressionTempBean.setClazz(this.serviceConfig.getValue(str + "." + clazz));
        expressionTempBean.setFilter(this.serviceConfig.getValue(str + "." + filter));
        String surl = this.serviceConfig.getValue(str + "." + serverUrl);
        String strTokenType = this.serviceConfig.getValue(str + "." + tokenType);
        if (strTokenType == null || strTokenType.equals("")) {
            expressionTempBean.setTokenType(this.esbBean.getTokenType());
        } else {
            expressionTempBean.setTokenType(TokenType.fromType(strTokenType));
        }
        String strDataType = this.serviceConfig.getValue(str + "." + dataType);
        if (strDataType == null || strDataType.equals("")) {
            expressionTempBean.setDataType(ContextType.Action);
        } else {
            expressionTempBean.setDataType(ContextType.fromType(strDataType));
        }
        String strReturnType = this.serviceConfig.getValue(str + "." + returntype);
        if (strReturnType == null || strReturnType.equals("")) {
            expressionTempBean.setReturntype(id);
        } else {
            expressionTempBean.setReturntype(strReturnType);
        }
        if (surl == null || surl.equals("")) {
            expressionTempBean.setServerUrl(this.esbBean.getServerUrl());
        } else {
            expressionTempBean.setServerUrl(surl);
        }
        if (expressionTempBean.getExpressionArr() == null) {
            if (expressionTempBean.getDataType().equals(ContextType.Server)) {
                expressionTempBean.setExpressionArr("GetClientService(\"" + expressionTempBean.getClazz() + "\",\"" + expressionTempBean.getServerUrl() + "\")");
            } else {
                expressionTempBean.setExpressionArr(expressionTempBean.getId() + "()");
            }
        }
        expressionTempBean.setFlowType(EsbFlowType.fromType(this.serviceConfig.getValue(str + "." + flowType)));
        expressionTempBean.setParams(this.getParams(str, this.serviceConfig));
        return expressionTempBean;
    }

    public ExpressionTempBean getNewExpressionTempBean(String id) {
        ExpressionTempBean expressionTempBean = new ExpressionTempBean();
        expressionTempBean.setId(id);
        return expressionTempBean;
    }

    @Override
    public ServiceBean getServiceConfigByName(String name) {
        return this.findServiceConfigMapByName().get(name);
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapByName() {
        String str = "templet.templetid";
        HashMap<String, ServiceBean> expressionTempBeanMap = new HashMap<String, ServiceBean>();
        String[] tempBeanIds = this.serviceConfig.getValues(str);
        if (tempBeanIds != null) {
            for (String tempBeanId : tempBeanIds) {
                ExpressionTempBean exb = this.getServiceConfigById(tempBeanId);
                expressionTempBeanMap.put(exb.getName(), exb);
            }
        }
        return expressionTempBeanMap;
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapById() {
        String str = "templet.templetid";
        HashMap<String, ServiceBean> expressionTempBeanMap = new HashMap<String, ServiceBean>();
        String[] tempBeanIds = this.serviceConfig.getValues(str);
        if (tempBeanIds != null) {
            for (String tempBeanId : tempBeanIds) {
                ExpressionTempBean exb = this.getServiceConfigById(tempBeanId);
                expressionTempBeanMap.put(tempBeanId, exb);
            }
        }
        return expressionTempBeanMap;
    }

    private List<ExpressionParameter> getParams(String beanNodePath, ServiceConfig serviceConfig) {
        String strParamStr = beanNodePath + "." + strParams;
        String[] paramIdArray = serviceConfig.getValues(strParamStr + "." + paramid);
        ArrayList<ExpressionParameter> paramsList = new ArrayList<ExpressionParameter>();
        if (paramIdArray == null) {
            return paramsList;
        }
        for (String paramId : paramIdArray) {
            String paramIdPath = strParamStr + "." + paramId;
            ExpressionTempParamBean<FormulaParams> param = new ExpressionTempParamBean<FormulaParams>();
            param.setParameterCode(serviceConfig.getValue(paramIdPath + "." + code));
            param.setParameterId(paramId);
            param.setParameterenName(serviceConfig.getValue(paramIdPath + "." + name));
            param.setParameterType(FormulaParams.fromType(serviceConfig.getValue(paramIdPath + "." + type)));
            param.setParameterDesc(serviceConfig.getValue(paramIdPath + "." + desc));
            paramsList.add(param);
        }
        return paramsList;
    }

    @Override
    public List<ServiceBean> loadAllService() {
        String str = "templet.templetid";
        ArrayList<ServiceBean> expressionTempBeanList = new ArrayList<ServiceBean>();
        String[] tempBeanIds = this.serviceConfig.getValues(str);
        if (tempBeanIds != null) {
            for (String tempBeanId : tempBeanIds) {
                ExpressionTempBean exb = this.getServiceConfigById(tempBeanId);
                expressionTempBeanList.add(exb);
            }
        }
        return expressionTempBeanList;
    }
}

