/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.manager;

import com.ds.common.expression.ExpressionParser;
import com.ds.common.expression.ExpressionParserManager;
import com.ds.common.expression.function.Function;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.DateUtility;
import com.ds.config.JDSConfig;
import com.ds.esb.config.invocation.AbstractInvocationHandler;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.EsbInvacationBean;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.expression.DefaultFunction;
import com.ds.esb.expression.EVALFunction;
import com.ds.esb.expression.RemoteFunction;
import com.ds.esb.util.EsbFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class JDSExpressionParserManager {
    static Log log = LogFactory.getLog("staticCache", JDSExpressionParserManager.class);
    public static final String CONSTANST_JDS_CONTEXT = "JDS_CONTEXT";
    public static final String CONSTANST_CURRENT_TIME = "CURRENT_TIME";
    public static final String CONSTANST_CURRENT_DATE = "CURRENT_DATE";
    public static final String CONSTANST_BOOLEAN_TRUE = "true";
    public static final String OBJECT = "object";
    public static final String CONSTANST_BOOLEAN_FALSE = "false";
    public static ExpressionParser parser = ExpressionParserManager.getExpressionParser();
    public static Map expressionTypeMap = new HashMap();
    public static Map typeMap = new HashMap();
    public static Map class2Map = new HashMap();
    public static Map fun2Map = new HashMap();
    public static Map name2functionMap = new HashMap();
    private static List<EsbInvacationBean> esbInvacationList = null;

    public static ExpressionParser getExpressionParser(Map ctx) {
        if (ctx == null) {
            ctx = new HashMap();
        }
        if (parser == null) {
            parser = ExpressionParserManager.getExpressionParser();
        }
        JDSExpressionParserManager.addConstants(parser, ctx);
        JDSExpressionParserManager.addFunctions(parser);
        if (!ctx.isEmpty()) {
            log.info("ctxInfo:" + ctx);
        }
        return parser;
    }

    private static void addConstants(ExpressionParser parser, Map ctx) {
        parser.addVariableAsObject(CONSTANST_JDS_CONTEXT, ctx);
        parser.addVariableAsObject(CONSTANST_CURRENT_TIME, new Timestamp(System.currentTimeMillis()));
        parser.addVariableAsObject(CONSTANST_CURRENT_DATE, DateUtility.getCurrentDate());
        parser.addVariableAsObject(CONSTANST_BOOLEAN_TRUE, true);
        parser.addVariableAsObject(OBJECT, new Object());
        parser.addVariableAsObject(CONSTANST_BOOLEAN_FALSE, false);
    }

    public static Object invacationExpression(Class clazz, Constructor constructor, Object[] arguments) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object obj = null;
        if (esbInvacationList == null) {
            esbInvacationList = new ArrayList<EsbInvacationBean>();
            List<? extends ServiceBean> expressionList = EsbBeanFactory.getInstance().loadAllServiceBean();
            for (int i = 0; i < expressionList.size(); ++i) {
                ServiceBean bean = expressionList.get(i);
                if (!(bean instanceof EsbInvacationBean) || esbInvacationList.contains(bean)) continue;
                esbInvacationList.add((EsbInvacationBean)bean);
            }
        }
        for (int k = 0; k < esbInvacationList.size(); ++k) {
            EsbInvacationBean esbInvacationBean = esbInvacationList.get(k);
            String filterName = esbInvacationBean.getFilter();
            try {
                Class invocation;
                Class filterClazz = ClassUtility.loadClass(filterName);
                if (!filterClazz.isAssignableFrom(clazz) || !AbstractInvocationHandler.class.isAssignableFrom(invocation = ClassUtility.loadClass(esbInvacationBean.getClazz()))) continue;
                AbstractInvocationHandler handler = (AbstractInvocationHandler)invocation.newInstance();
                obj = handler.getBean(clazz, constructor.getParameterTypes(), arguments);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj == null) {
            if (constructor == null || constructor.getParameterTypes().length == 0) {
                try {
                    obj = clazz.getDeclaredConstructor(null).newInstance(arguments);
                }
                catch (Exception e) {
                    obj = constructor.newInstance(arguments);
                }
            } else {
                obj = constructor.newInstance(arguments);
            }
        }
        return obj;
    }

    static void fullBean(ExpressionTempBean bean) {
        String className = bean.getClazz();
        Class clazz = null;
        try {
            clazz = ClassUtility.loadClass(className);
        }
        catch (Throwable e) {
            log.warn("when EsbBus load static " + className + " not found '" + bean.getId() + "[" + bean.getClazz() + "]'in path '" + bean + "'");
            return;
        }
        try {
            Function function = null;
            if (clazz != null) {
                if (Function.class.isAssignableFrom(clazz)) {
                    function = (Function)ClassUtility.loadClass(className).newInstance();
                    if (bean.getReturntype() != null) {
                        parser.addFunction(bean.getReturntype(), function);
                        Class returnTypeClz = JDSExpressionParserManager.findClassByKey(bean.getReturntype());
                        fun2Map.put(bean.getId(), clazz);
                        typeMap.put(bean.getId(), clazz);
                        expressionTypeMap.put(bean.getId(), returnTypeClz);
                    }
                } else if (bean.getServerUrl() != null && !bean.getServerUrl().equals("")) {
                    function = new RemoteFunction(clazz.getName(), bean.getServerUrl());
                    class2Map.put(bean.getId(), clazz);
                    typeMap.put(bean.getId(), clazz);
                    parser.addFunction(clazz.getSimpleName(), function);
                    expressionTypeMap.put(bean.getId(), clazz);
                } else {
                    function = new DefaultFunction(clazz, bean.getExpressionArr());
                    class2Map.put(bean.getId(), clazz);
                    typeMap.put(bean.getId(), clazz);
                    parser.addFunction(clazz.getSimpleName(), function);
                    expressionTypeMap.put(bean.getId(), clazz);
                }
            }
            EVALFunction $function = new EVALFunction(bean.getExpressionArr());
            parser.addFunction("$" + bean.getId(), $function);
            name2functionMap.put(bean.getReturntype(), function);
            name2functionMap.put("$" + bean.getId(), $function);
            name2functionMap.put("get$" + bean.getId(), $function);
        }
        catch (Exception e) {
            log.warn("when EsbBus load static data not found '" + bean.getId() + "[" + bean.getClazz() + "]", e);
        }
    }

    public static Map loadStaticAllData(boolean reload) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (parser == null) {
            parser = ExpressionParserManager.getExpressionParser();
        }
        Hashtable functionMap = parser.getFunctionTable();
        Map valueMap = (Map)EsbFactory.getDefauleRoot();
        if (valueMap == null || valueMap.size() == 0 || reload) {
            List<? extends ServiceBean> expressionList = EsbBeanFactory.getInstance().loadAllServiceBean();
            ArrayList tempBeans = new ArrayList();
            for (ServiceBean serviceBean : expressionList) {
                if (!(serviceBean instanceof ExpressionTempBean)) continue;
                JDSExpressionParserManager.fullBean((ExpressionTempBean)serviceBean);
            }
        }
        return valueMap;
    }

    private static Class findClassByKey(String key) throws SecurityException, NoSuchMethodException {
        Hashtable expression;
        Class<?> clazz = null;
        if (key != null && (expression = parser.getFunctionTable()) != null && expression.containsKey(key.toLowerCase())) {
            clazz = expression.get(key).getClass();
            try {
                Method[] methods = clazz.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().equals("perform")) continue;
                    clazz = method.getReturnType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz;
    }

    private static void addFunctions(ExpressionParser parser) {
        String[] functions = JDSConfig.getChildrenProperties("functions");
        for (int i = 0; i < functions.length; ++i) {
            String className = JDSConfig.getValue("functions." + functions[i] + ".class");
            try {
                Function function = (Function)Class.forName(className).newInstance();
                parser.addFunction(functions[i], function);
                continue;
            }
            catch (ClassNotFoundException e) {
                log.error("ClassNotFoundException", e);
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e1) {
                log.error("IllegalAccessException", e1);
                e1.printStackTrace();
                continue;
            }
            catch (InstantiationException e2) {
                log.error("InstantiationException", e2);
                e2.printStackTrace();
            }
        }
    }

    public static String verifyExpression(String expression, List parameterList) {
        HashMap ctx = new HashMap();
        ExpressionParser parser = JDSExpressionParserManager.getExpressionParser(ctx);
        boolean result = parser.parseExpression(expression);
        return result ? "OK" : parser.getErrorInfo();
    }

    public static Map getExpressionTypeMap() {
        return expressionTypeMap;
    }

    public static Map getClass2Map() {
        return class2Map;
    }

    public static void setClass2Map(Map class2Map) {
        JDSExpressionParserManager.class2Map = class2Map;
    }

    public static Map getFun2Map() {
        return fun2Map;
    }

    public static void setFun2Map(Map fun2Map) {
        JDSExpressionParserManager.fun2Map = fun2Map;
    }

    public static Map getTypeMap() {
        return typeMap;
    }

    public static void setTypeMap(Map typeMap) {
        JDSExpressionParserManager.typeMap = typeMap;
    }

    public static Map getName2functionMap() {
        return name2functionMap;
    }

    public static void setName2functionMap(Map name2functionMap) {
        JDSExpressionParserManager.name2functionMap = name2functionMap;
    }
}

