/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.invocation;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.util.Debug;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.VariableResolverFactory;

public class DebugInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog("JDS", DebugInterceptor.class);
    Debug debug = new Debug();

    public int doBefore(ASTNode node, VariableResolverFactory factory) {
        logger.info("************************************************");
        logger.info("----- expression " + node.getName() + " par start");
        this.debug.setName(node.getName());
        this.debug.setStartTime(System.currentTimeMillis());
        return 0;
    }

    public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
        this.debug.setEndTime(System.currentTimeMillis());
        logger.info("************************************************");
        long timeLoadOrg = System.currentTimeMillis() - this.debug.getStartTime();
        logger.info("----- par " + this.debug.getName() + " in " + timeLoadOrg / 1000L + "s:" + timeLoadOrg % 1000L + " -----");
        logger.info("************************************************");
        return 0;
    }
}

