/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esb.config.annotation;

import com.ds.command.JDSCommand;
import com.ds.common.expression.function.Function;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.JarLoader;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.JDSBusException;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.NotFoundException;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotationtExpressionTempManager
implements ServiceConfigManager {
    private static final Log logger = LogFactory.getLog("JDS", AbstractAnnotationtExpressionTempManager.class);
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationtExpressionTempManager.class);
    public Set<Class<?>> classList = new HashSet();
    private static Map<Class, String> pathMap = new HashMap<Class, String>();
    public Map<String, ServiceBean> nameMap = new HashMap<String, ServiceBean>();
    public Map<String, ServiceBean> idMap = new HashMap<String, ServiceBean>();
    public List<ServiceBean> serviceBeanList = new ArrayList<ServiceBean>();
    public EsbBean esbBean;

    public EsbBean getEsbBean() {
        return this.esbBean;
    }

    public void setEsbBean(EsbBean esbBean) {
        this.esbBean = esbBean;
    }

    @Override
    public List<ServiceBean> loadAllService() {
        return this.serviceBeanList;
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapById() {
        return this.idMap;
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapByName() {
        return this.nameMap;
    }

    @Override
    public ServiceBean getServiceConfigById(String id) {
        return this.idMap.get(id);
    }

    @Override
    public ServiceBean getServiceConfigByName(String name) {
        return this.nameMap.get(name);
    }

    public void fillBean(Class clazz, Map valueMap) {
        if (pathMap.containsKey(clazz)) {
            String path = pathMap.get(clazz);
            valueMap.put("path", path);
            if (path.endsWith("class")) {
                File file = new File(pathMap.get(clazz));
                valueMap.put("creatTime", file.lastModified());
            }
        }
        try {
            Annotation[] annotations = clazz.getAnnotations();
            for (int j = 0; j < annotations.length; ++j) {
                Annotation annotation = annotations[j];
                Class<? extends Annotation> enumType = annotation.annotationType();
                try {
                    ClassMappingAnnotation classMappingAnnotation = annotation.annotationType().getAnnotation(ClassMappingAnnotation.class);
                    if (classMappingAnnotation == null || !ServiceBean.class.isAssignableFrom(classMappingAnnotation.clazz())) continue;
                    for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
                        Method method = enumType.getDeclaredMethods()[k];
                        valueMap.put(method.getName(), method.invoke((Object)annotation, null));
                    }
                    ServiceBean bean = (ServiceBean)classMappingAnnotation.clazz().newInstance();
                    BeanMap beanMap = BeanMap.create((Object)bean);
                    beanMap.putAll(valueMap);
                    if (Function.class.isAssignableFrom(clazz)) {
                        Class innerClass = AbstractAnnotationtExpressionTempManager.getInnerClass("perform", clazz);
                        beanMap.put((Object)"clazz", (Object)clazz.getName());
                    } else {
                        if (valueMap.get("clazz") == null || valueMap.get("clazz").equals("")) {
                            beanMap.put((Object)"clazz", (Object)clazz.getName());
                        }
                        if (valueMap.get("clazz") == null || valueMap.get("clazz").equals("")) {
                            beanMap.put((Object)"clazz", (Object)clazz.getName());
                        }
                        if (valueMap.get("id") == null || valueMap.get("id").equals("")) {
                            beanMap.put((Object)"id", (Object)clazz.getSimpleName());
                        }
                    }
                    if (valueMap.get("expressionArr") == null || valueMap.get("expressionArr").equals("")) {
                        beanMap.put((Object)"expressionArr", (Object)(clazz.getSimpleName() + "()"));
                    }
                    beanMap.put((Object)"mainClass", (Object)clazz.getName());
                    String returntype = (String)beanMap.get((Object)"expressionArr");
                    if (JDSCommand.class.isAssignableFrom(clazz)) {
                        beanMap.put((Object)"flowType", (Object)EsbFlowType.command);
                    }
                    if (returntype != null && !returntype.equals("")) {
                        beanMap.put((Object)"returntype", (Object)returntype.substring(0, returntype.indexOf("(")));
                    }
                    if (this.idMap.containsKey(bean.getId())) {
                        ServiceBean oldBean = this.idMap.get(bean.getId());
                        if (bean.getVersion() > oldBean.getVersion()) {
                            this.serviceBeanList.remove(this.idMap.get(bean.getId()));
                            this.serviceBeanList.add(bean);
                            this.nameMap.put(bean.getName(), bean);
                            this.idMap.put(bean.getId(), bean);
                            continue;
                        }
                        if (bean.getVersion() != oldBean.getVersion()) continue;
                        if (!oldBean.getClazz().equals(bean.getClazz())) {
                            logger.error("load bean err beanid=<<" + oldBean.getId() + ">> def in 2 class [" + oldBean.getClazz() + "," + bean.getClazz() + "]");
                        }
                        this.serviceBeanList.remove(this.idMap.get(bean.getId()));
                        this.serviceBeanList.add(bean);
                        this.nameMap.put(bean.getName(), bean);
                        this.idMap.put(bean.getId(), bean);
                        continue;
                    }
                    this.serviceBeanList.add(bean);
                    this.nameMap.put(bean.getName(), bean);
                    this.idMap.put(bean.getId(), bean);
                    continue;
                }
                catch (Throwable e) {
                    log.info("Error load  class==" + clazz.getName());
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            log.info("Error load  class==" + clazz.getName());
            e.printStackTrace();
        }
    }

    @Override
    public Set<Class<?>> init() throws JDSBusException {
        String parma = this.esbBean.getPath();
        log.info("path====================================:" + parma);
        String[] pathArr = parma.split(";");
        for (int k = 0; k < pathArr.length; ++k) {
            String path = pathArr[k];
            try {
                String fileName;
                String absolutePath;
                if (path.indexOf(":") > -1) {
                    File[] files;
                    String[] paths = path.split(":");
                    String pattern = paths[1];
                    String folderPath = this.getRootPath(paths[0]);
                    File file = new File(folderPath);
                    if (!file.exists()) {
                        throw new IOException("file [" + path + "] load error! folderPath=" + folderPath);
                    }
                    if (file.isFile()) {
                        throw new IOException("file [" + path + "] not  folder! ");
                    }
                    log.info(pattern + " load success: start load:" + file.getAbsolutePath());
                    if (!Paths.get(folderPath, new String[0]).toFile().isDirectory()) continue;
                    for (File cfile : files = file.listFiles()) {
                        Pattern p = Pattern.compile(pattern);
                        Matcher matcher = p.matcher(cfile.getName());
                        if (!matcher.find() || !cfile.getName().endsWith("jar")) continue;
                        this.classList.addAll(this.initJar(cfile.getAbsolutePath()));
                        log.info(pattern + " pattern success: start load:" + cfile.getName());
                    }
                    continue;
                }
                if (path.endsWith(".jar")) {
                    String rootPath = this.getRootPath(path);
                    this.classList.addAll(this.initJar(rootPath));
                    continue;
                }
                File file = new File(path);
                if (path.startsWith(File.separator)) {
                    absolutePath = JDSConfig.getAbsolutePath("", this.getClass());
                    log.info("absolutePath:" + absolutePath);
                    fileName = absolutePath + StringUtility.replace(path.substring(0, path.length() - 4), File.separator, "/");
                    log.info("realPah:{}", (Object)path);
                    file = new File(fileName);
                } else if (path.equals("*")) {
                    file = new File(JDSConfig.getAbsolutePath("", null));
                } else if (!path.equals("*") && path.startsWith("*")) {
                    absolutePath = JDSConfig.getAbsolutePath("", null);
                    log.info("*absolutePath:" + path);
                    fileName = absolutePath + StringUtility.replace(path.substring(1, path.length()), ".", File.separator);
                    file = new File(fileName);
                }
                this.toFileNames(file);
                continue;
            }
            catch (Exception e1) {
                throw new JDSBusException(pathArr[k] + " load Err  context=" + JDSConfig.getAbsolutePath("", this.getClass()), e1);
            }
        }
        this.fillBean(this.classList);
        return this.classList;
    }

    protected abstract void fillBean(Set<Class<?>> var1);

    public void toFileNames(File src) throws IOException {
        File[] chs = src.listFiles();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i].isFile()) {
                String path = chs[i].getPath();
                if (path.endsWith(".class")) {
                    String absolutePath = JDSConfig.getAbsolutePath("", this.getClass());
                    absolutePath = StringUtility.replace(absolutePath, "/", File.separator);
                    if ((absolutePath = StringUtility.replace(absolutePath, "\\", File.separator)).startsWith(File.separator)) {
                        absolutePath = absolutePath.substring(1, absolutePath.length());
                    }
                    String className = StringUtility.replace(path, absolutePath, "");
                    className = StringUtility.replace(className, File.separator, ".");
                    className = className.substring(0, className.length() - 6);
                    try {
                        Class clazz = ClassUtility.loadClass(className);
                        this.classList.add(clazz);
                        pathMap.put(clazz, chs[i].getAbsolutePath());
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    continue;
                }
                if (!path.endsWith(".jar")) continue;
                String rootPath = this.getRootPath(path);
                this.initJar(rootPath);
                continue;
            }
            this.toFileNames(chs[i]);
        }
    }

    private String getRootPath(String path) {
        log.info("originPath=[{}]", (Object)path);
        String rootPath = StringUtility.replace(path, "\\", File.separator);
        rootPath = StringUtility.replace(path, "/", File.separator);
        rootPath = StringUtility.replace(rootPath, "\\", File.separator);
        log.info("originPathAfterReplace=[{}]", (Object)rootPath);
        if (path.startsWith("JDSHome")) {
            rootPath = StringUtility.replace(path, "JDSHome", JDSConfig.getServerHome());
        } else if (path.startsWith("/") || path.startsWith("\\")) {
            String classPath = "";
            if (JDSConfig.getAbsolutePath("", this.getClass()).indexOf("WEB-INF/") > -1) {
                log.info("[{}]has[WEB-INF]", (Object)path);
                classPath = JDSConfig.getAbsolutePath("", this.getClass()).substring(0, JDSConfig.getAbsolutePath("", this.getClass()).indexOf("WEB-INF/"));
            } else {
                classPath = JDSConfig.getAbsolutePath("", this.getClass()).indexOf("bin/") > -1 ? JDSConfig.getAbsolutePath("", this.getClass()).substring(0, JDSConfig.getAbsolutePath("", this.getClass()).indexOf("bin/")) : JDSConfig.getAbsolutePath("", this.getClass());
            }
            classPath = StringUtility.replace(classPath, "/", File.separator);
            classPath = StringUtility.replace(classPath, "\\", File.separator);
            if (rootPath.startsWith(File.separator)) {
                rootPath = rootPath.substring(1, rootPath.length());
            }
            rootPath = classPath + rootPath;
            log.info("[{}]OS", (Object)OS);
            if (OS.indexOf("window") > -1 && rootPath.startsWith(File.separator)) {
                rootPath = rootPath.substring(1, rootPath.length());
            }
        }
        return rootPath;
    }

    private Set<Class<?>> initJar(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("file [" + path + "] load error! ");
        }
        JarLoader loader = new JarLoader(file, this.getClass().getClassLoader());
        ClassPool pool = ClassPool.getDefault();
        try {
            pool.appendClassPath(file.getPath());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return loader.getAllClassByPackage();
    }

    public static Class getInnerClass(String fieldName, Class listClass) {
        Class innerClazz = null;
        try {
            Class clazz = null;
            String className = listClass.getName();
            if (className.indexOf("$$") > -1) {
                className = className.substring(0, className.indexOf("$$"));
            }
            if ((innerClazz = AbstractAnnotationtExpressionTempManager.findClassByKey(clazz = ClassUtility.loadClass(className), fieldName)) == null) {
                String getmethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                innerClazz = AbstractAnnotationtExpressionTempManager.findClassByKey(clazz, getmethodName);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return innerClazz;
    }

    private static Class findClassByKey(Class clazz, String methodName) {
        Class classzz = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            if (!List.class.isAssignableFrom(method.getReturnType())) {
                classzz = method.getReturnType();
                continue;
            }
            try {
                Type type = method.getGenericReturnType();
                classzz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                continue;
            }
            catch (SecurityException e) {
                log.error("SecurityException fieldName=" + methodName + "  in class" + clazz.getName());
            }
        }
        return classzz;
    }
}

