/*
 * Decompiled with CFR 0.152.
 */
package com.ds.engine.event;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.config.JDSConfig;
import com.ds.engine.event.EIServerEvent;
import com.ds.engine.event.EIServerListener;
import com.ds.engine.event.JDSEvent;
import com.ds.engine.event.JDSEventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EventControl
implements JDSEventDispatcher {
    private static final Log logger = LogFactory.getLog("JDS", EventControl.class);
    private static EventControl instance = null;
    public List<EIServerListener> coreServerEventListeners = new ArrayList<EIServerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventControl getInstance() {
        if (instance != null) return instance;
        Class<EventControl> clazz = EventControl.class;
        synchronized (EventControl.class) {
            if (instance != null) return instance;
            instance = new EventControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected EventControl() {
        this.initCoreListeners();
    }

    private void dispatchCoreServerEvent(EIServerEvent event) throws JDSException {
        EIServerEvent se = event;
        Iterator<EIServerListener> it = this.coreServerEventListeners.iterator();
        block16: while (it.hasNext()) {
            try {
                EIServerListener listener = it.next();
                switch (se.getID()) {
                    case serverStarting: {
                        listener.serverStarting(se);
                        continue block16;
                    }
                    case serverStarted: {
                        listener.serverStarted(se);
                        continue block16;
                    }
                    case serverStopping: {
                        listener.serverStopping(se);
                        continue block16;
                    }
                    case serverStopped: {
                        listener.serverStopped(se);
                        continue block16;
                    }
                    case systemSaving: {
                        listener.systemSaving(se);
                        continue block16;
                    }
                    case systemSaved: {
                        listener.systemSaved(se);
                        continue block16;
                    }
                    case systemDeleting: {
                        listener.systemDeleting(se);
                        continue block16;
                    }
                    case systemDeleted: {
                        listener.systemDeleted(se);
                        continue block16;
                    }
                    case systemActivating: {
                        listener.systemActivating(se);
                        continue block16;
                    }
                    case systemActivated: {
                        listener.systemActivated(se);
                        continue block16;
                    }
                    case systemFreezing: {
                        listener.systemFreezing(se);
                        continue block16;
                    }
                    case systemFreezed: {
                        listener.systemFreezed(se);
                        continue block16;
                    }
                }
                throw new JDSException("Unsupport server event type: " + se.getID(), 30);
            }
            catch (Throwable e) {
                logger.warn("Listener execute failed!", e);
            }
        }
    }

    protected void initCoreListeners() {
        String[] serverListeners = JDSConfig.getValues("event.ServerEventListeners.listener");
        if (serverListeners != null) {
            for (int i = 0; i < serverListeners.length; ++i) {
                String listener = serverListeners[i];
                try {
                    EIServerListener serverListener = (EIServerListener)ClassUtility.loadClass(listener).newInstance();
                    this.coreServerEventListeners.add(serverListener);
                    continue;
                }
                catch (Exception e) {
                    logger.error("", e);
                }
            }
        }
        this.coreServerEventListeners = Collections.unmodifiableList(this.coreServerEventListeners);
    }

    public void dispatchEvent(final JDSEvent event) throws JDSException {
        if (event != null && event instanceof EIServerEvent) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        EventControl.this.dispatchCoreServerEvent((EIServerEvent)event);
                    }
                    catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }
}

