/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtility {
    static DocumentBuilderFactory factory;
    static DocumentBuilder builder;

    public static void renderXmlStream(Reader xmlInput, Writer htmlOutput, Reader xslInput) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslInput));
            xslInput.close();
            transformer.setOutputProperty("encoding", "GB2312");
            transformer.setOutputProperty("method", "html");
            transformer.transform(new StreamSource(xmlInput), new StreamResult(htmlOutput));
            xmlInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderXmlStream(Reader xmlInput, Writer htmlOutput, String xsl) {
        try {
            FileReader xslInput = new FileReader(xsl);
            XMLUtility.renderXmlStream(xmlInput, htmlOutput, xslInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String renderXmlStream(Reader xmlInput, String xsl) {
        StringWriter sw = new StringWriter();
        XMLUtility.renderXmlStream(xmlInput, (Writer)sw, xsl);
        sw.flush();
        return sw.toString();
    }

    public static Document readXMLDoc(String strFile) {
        try {
            FileInputStream in = new FileInputStream(strFile);
            return XMLUtility.readXMLDoc(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document readXMLDoc(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            return XMLUtility.readXMLDoc(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document readXMLDoc(InputStream in) {
        Document doc = null;
        try {
            doc = builder.parse(in);
            doc.normalize();
            in.close();
            return doc;
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6\u6d41\u7a0b\u63a7\u5236\u6587\u4ef6\u9519\u8bef in ProcessManager::readXMLDoc();");
            e.printStackTrace();
            return null;
        }
    }

    public static String getNodeValue(Node node) {
        try {
            String str = node.getFirstChild().getNodeValue();
            return str.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getChildValue(Element node, String strChild) {
        try {
            NodeList list = node.getElementsByTagName(strChild);
            String str = XMLUtility.getNodeValue(list.item(0));
            return str.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Node getFirstChild(Node node, String childName) {
        if (node == null || childName == null || childName.trim().equals("")) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!childNode.getNodeName().equals(childName)) continue;
            return childNode;
        }
        return null;
    }

    public static List getChildNodes(Node node, short type) {
        ArrayList<Node> retList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != type) continue;
            retList.add(childNode);
        }
        return retList;
    }

    public static Node getFirstChild(Node node, short type) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != type) continue;
            return childNode;
        }
        return null;
    }

    static {
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

