/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import java.util.Date;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public class TaskEngine {
    public static final int HIGH_PRIORITY = 2;
    public static final int MEDIUM_PRIORITY = 1;
    public static final int LOW_PRIORITY = 0;
    private static PriorityQueue taskQueue = null;
    private static ThreadGroup threadGroup;
    private static TaskEngineWorker[] workers;
    private static Timer taskTimer;
    private static Object lock;
    private static long newWorkerTimestamp;
    private static long busyTimestamp;

    private TaskEngine() {
    }

    public static void addTask(Runnable task) {
        TaskEngine.addTask(1, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTask(int priority, Runnable task) {
        Object object = lock;
        synchronized (object) {
            taskQueue.enqueue(priority, task);
            lock.notify();
        }
    }

    public static TimerTask scheduleTask(Runnable task, Date date) {
        return TaskEngine.scheduleTask(1, task, date);
    }

    public static TimerTask scheduleTask(int priority, Runnable task, Date date) {
        ScheduledTask timerTask = new ScheduledTask(priority, task);
        taskTimer.schedule((TimerTask)timerTask, date);
        return timerTask;
    }

    public static TimerTask scheduleTask(Runnable task, long delay, long period) {
        return TaskEngine.scheduleTask(1, task, delay, period);
    }

    public static TimerTask scheduleTask(int priority, Runnable task, long delay, long period) {
        ScheduledTask timerTask = new ScheduledTask(priority, task);
        taskTimer.scheduleAtFixedRate((TimerTask)timerTask, delay, period);
        return timerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Runnable nextTask() {
        Object object = lock;
        synchronized (object) {
            boolean busy;
            while (taskQueue.isEmpty()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = busy = (double)taskQueue.size() > Math.ceil(workers.length / 2);
            if (busy) {
                busyTimestamp = TaskEngine.currentTime();
                TaskEngine.addWorker();
            } else {
                TaskEngine.removeWorker();
            }
            return (Runnable)taskQueue.dequeue();
        }
    }

    private static void addWorker() {
        if (workers.length < 30 && TaskEngine.currentTime() > newWorkerTimestamp + 2000L) {
            int newSize = workers.length + 1;
            int lastIndex = newSize - 1;
            TaskEngineWorker[] newWorkers = new TaskEngineWorker[newSize];
            for (int i = 0; i < workers.length; ++i) {
                newWorkers[i] = workers[i];
            }
            newWorkers[lastIndex] = new TaskEngineWorker("Task Engine Worker " + lastIndex);
            newWorkers[lastIndex].setDaemon(true);
            newWorkers[lastIndex].start();
            workers = newWorkers;
            newWorkerTimestamp = TaskEngine.currentTime();
        }
    }

    private static void removeWorker() {
        if (workers.length > 3 && TaskEngine.currentTime() > busyTimestamp + 5000L) {
            workers[workers.length - 1].stopWorker();
            int newSize = workers.length - 1;
            TaskEngineWorker[] newWorkers = new TaskEngineWorker[newSize];
            for (int i = 0; i < newSize; ++i) {
                newWorkers[i] = workers[i];
            }
            workers = newWorkers;
            busyTimestamp = TaskEngine.currentTime();
        }
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    static {
        workers = null;
        taskTimer = null;
        lock = new Object();
        newWorkerTimestamp = TaskEngine.currentTime();
        busyTimestamp = TaskEngine.currentTime();
        taskTimer = new Timer(true);
        taskQueue = new PriorityQueue();
        threadGroup = new ThreadGroup("Task Engine Workers");
        workers = new TaskEngineWorker[5];
        for (int i = 0; i < workers.length; ++i) {
            TaskEngine.workers[i] = new TaskEngineWorker("Task Engine Worker " + i);
            workers[i].setDaemon(true);
            workers[i].start();
        }
    }

    private static class PriorityQueue {
        private LinkedList high = new LinkedList();
        private LinkedList medium = new LinkedList();
        private LinkedList low = new LinkedList();

        private PriorityQueue() {
        }

        public void enqueue(int priority, Object object) {
            if (priority > 2) {
                priority = 2;
            } else if (priority < 0) {
                priority = 0;
            }
            switch (priority) {
                case 2: {
                    this.high.addFirst(object);
                    break;
                }
                case 1: {
                    this.medium.addFirst(object);
                    break;
                }
                case 0: {
                    this.low.addFirst(object);
                }
            }
        }

        public boolean isEmpty() {
            return this.high.isEmpty() && this.medium.isEmpty() && this.low.isEmpty();
        }

        public int size() {
            return this.high.size() + this.medium.size() + this.low.size();
        }

        public Object dequeue() {
            Object object = null;
            if (!this.high.isEmpty()) {
                object = this.high.removeLast();
            } else if (!this.medium.isEmpty()) {
                object = this.medium.removeLast();
            } else if (!this.low.isEmpty()) {
                object = this.low.removeLast();
            } else {
                throw new NoSuchElementException("Queue is empty.");
            }
            if (!this.low.isEmpty()) {
                this.medium.addFirst(this.low.removeLast());
            }
            if (!this.medium.isEmpty()) {
                this.high.addFirst(this.medium.removeLast());
            }
            return object;
        }
    }

    private static class ScheduledTask
    extends TimerTask {
        private int priority;
        private Runnable task;

        public ScheduledTask(int priority, Runnable task) {
            this.priority = priority;
            this.task = task;
        }

        @Override
        public void run() {
            TaskEngine.addTask(this.priority, this.task);
        }
    }

    private static class TaskEngineWorker
    extends Thread {
        private boolean done = false;

        public TaskEngineWorker(String name) {
            super(threadGroup, name);
        }

        public void stopWorker() {
            this.done = true;
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    TaskEngine.nextTask().run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

