/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.util.ClassUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarLoader
extends ClassLoader {
    private JarFile jarFile;
    private static Hashtable<String, Set<Class<?>>> classMaps = new Hashtable();

    private void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public JarLoader(ClassLoader parent) {
        super(parent);
    }

    public JarLoader(String jarPath) throws IOException {
        super(Thread.currentThread().getContextClassLoader());
        this.jarFile = new JarFile(jarPath);
    }

    public JarLoader(File jarFile) throws IOException {
        super(Thread.currentThread().getContextClassLoader());
        this.jarFile = new JarFile(jarFile);
    }

    public JarLoader(File jarFile, ClassLoader parent) throws IOException {
        super(parent);
        this.jarFile = new JarFile(jarFile);
    }

    public Set<Class<?>> getAllClassByPackage() throws IOException {
        return this.getClassByPackage("", false);
    }

    public Set<Class<?>> getAllClassByPackage(boolean reload) throws IOException {
        return this.getClassByPackage("", reload);
    }

    public Set<Class<?>> getClassByPackage(String name) throws IOException {
        return this.getClassByPackage(name, false);
    }

    public Set<Class<?>> getClassByPackage(String name, boolean reload) throws IOException {
        Set<Class<?>> classes = classMaps.get(this.jarFile.getName() + name);
        if (classes == null) {
            classes = this.loadClasses(name);
            classMaps.put(this.jarFile.getName() + name, classes);
        } else if (reload) {
            JarLoader loader = new JarLoader(this.getParent());
            loader.setJarFile(this.jarFile);
            classes = loader.loadClasses(name);
            classMaps.put(this.jarFile.getName() + name, classes);
        }
        return classes;
    }

    private Set<Class<?>> loadClasses(String packageName) throws IOException {
        String tmpName = packageName.replace('.', '/');
        JarEntry entry = null;
        Enumeration<JarEntry> es = this.jarFile.entries();
        HashSet classes = new HashSet();
        while (es.hasMoreElements()) {
            entry = es.nextElement();
            String eName = entry.getName();
            if (!eName.endsWith(".class") || !"".equals(tmpName) && !eName.startsWith(tmpName) || this.getClassByEntry(entry) == null) continue;
            classes.add(this.getClassByEntry(entry));
        }
        return classes;
    }

    private byte[] loadJava(String className) throws IOException {
        String tmpName = className.replace('.', '/');
        byte[] bs = null;
        JarEntry entry = null;
        Enumeration<JarEntry> es = this.jarFile.entries();
        HashSet classes = new HashSet();
        while (es.hasMoreElements()) {
            entry = es.nextElement();
            String eName = entry.getName();
            if (!eName.endsWith(".java") || !eName.startsWith(tmpName)) continue;
            bs = this.getEntryBytes(entry);
        }
        return bs;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = super.loadClass(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassUtility.loadClass(name);
    }

    private Class getClassByEntry(JarEntry entry) throws IOException {
        String name = entry.getName();
        if ((name = name.replace('/', '.')).endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        Class<?> c = null;
        try {
            c = super.loadClass(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (c == null) {
            byte[] bs = this.getEntryBytes(entry);
            try {
                c = super.defineClass(name, bs, 0, bs.length);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return c;
    }

    private byte[] getEntryBytes(JarEntry entry) throws IOException {
        InputStream is = this.jarFile.getInputStream(entry);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
        int c = 0;
        byte[] buff = new byte[10240];
        while ((c = is.read(buff)) > 0) {
            bos.write(buff, 0, c);
        }
        is.close();
        return bos.toByteArray();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz.getPackage() == null) {
            String packageName = name.substring(0, name.lastIndexOf("."));
            this.definePackage(packageName, "ESDDynPackage", "1.0.0", "ESD", null, null, null, null);
        }
        return clazz;
    }
}

