/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImgUtil {
    public static void scaleByWidth(String srcImageFile, String resultImageFile, int cWidth) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int width = src.getWidth();
            int scale = width / cWidth;
            ImgUtil.scale(srcImageFile, resultImageFile, scale, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scaleByHeight(String srcImageFile, String resultImageFile, int cHeight) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int height = src.getHeight();
            int scale = height / cHeight;
            ImgUtil.scale(srcImageFile, resultImageFile, scale, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scale(String srcImageFile, String resultImageFile, int scale, boolean flag) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            ImgUtil.scale(src, resultImageFile, scale, flag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void scale(BufferedImage src, String resultImageFile, int scale, boolean flag) throws IOException {
        int width = src.getWidth();
        int height = src.getHeight();
        if (flag) {
            width *= scale;
            height *= scale;
        } else {
            width /= scale;
            height /= scale;
        }
        Image image = src.getScaledInstance(width, height, 1);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageIO.write((RenderedImage)tag, "png", new File(resultImageFile));
    }
}

