/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class IOUtility {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtility() {
    }

    public static void shutdownReader(Reader input) {
        if (null == input) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownWriter(Writer output) {
        if (null == output) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(OutputStream output) {
        if (null == output) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(InputStream input) {
        if (null == input) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void copy(Reader input, Writer output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(InputStream input, File file) throws IOException {
        if (input != null) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream output = new FileOutputStream(file);
            IOUtility.copy(input, (OutputStream)output);
            IOUtility.shutdownStream(input);
            IOUtility.shutdownStream(output);
        }
    }

    public static void copy(InputStream input, Writer output, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtility.copy((Reader)in, output, bufferSize);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtility.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtility.copy((Reader)in, output, bufferSize);
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtility.toString(input, 4096);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtility.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return IOUtility.toString(input, encoding, 4096);
    }

    public static String toString(InputStream input, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtility.copy(input, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtility.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(InputStream input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtility.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(Reader input, OutputStream output, int bufferSize) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtility.copy(input, (Writer)out, bufferSize);
        out.flush();
    }

    public static String toString(Reader input) throws IOException {
        return IOUtility.toString(input, 4096);
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtility.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        return IOUtility.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(Reader input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtility.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(String input, OutputStream output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(String input, OutputStream output, int bufferSize) throws IOException {
        StringReader in = new StringReader(input);
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtility.copy((Reader)in, (Writer)out, bufferSize);
        out.flush();
    }

    public static void copy(String input, Writer output) throws IOException {
        output.write(input);
    }

    public static void bufferedCopy(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        IOUtility.copy((InputStream)in, (OutputStream)out);
        out.flush();
    }

    public static byte[] toByteArray(String input) throws IOException {
        return IOUtility.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(String input, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtility.copy(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void copy(byte[] input, Writer output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(byte[] input, Writer output, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtility.copy((InputStream)in, output, bufferSize);
    }

    public static void copy(byte[] input, Writer output, String encoding) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtility.copy((InputStream)in, output, encoding);
    }

    public static void copy(byte[] input, Writer output, String encoding, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtility.copy(in, output, encoding, bufferSize);
    }

    public static String toString(byte[] input) throws IOException {
        return IOUtility.toString(input, 4096);
    }

    public static String toString(byte[] input, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtility.copy(input, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(byte[] input, String encoding) throws IOException {
        return IOUtility.toString(input, encoding, 4096);
    }

    public static String toString(byte[] input, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtility.copy(input, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static void copy(byte[] input, OutputStream output) throws IOException {
        IOUtility.copy(input, output, 4096);
    }

    public static void copy(byte[] input, OutputStream output, int bufferSize) throws IOException {
        output.write(input);
    }

    public static void copy(File input, File output) throws IOException {
        FileInputStream fis = new FileInputStream(input);
        FileOutputStream fos = new FileOutputStream(output);
        IOUtility.copy((InputStream)fis, (OutputStream)fos);
        fis.close();
        fos.flush();
        fos.close();
    }

    public static void xcopy(File srcDir, File destineDir) throws IOException {
        try {
            if (!srcDir.exists() || srcDir.getCanonicalPath().equals(destineDir.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!destineDir.exists()) {
            destineDir.mkdirs();
        }
        File[] chs = srcDir.listFiles();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i].isFile()) {
                File destineFile = new File(destineDir, chs[i].getName());
                IOUtility.copy(chs[i], destineFile);
                continue;
            }
            File destine = new File(destineDir, chs[i].getName());
            destine.mkdirs();
            IOUtility.xcopy(chs[i], destine);
        }
    }

    public static void write(InputStream is, OutputStream os) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        byte[] bs = new byte[8192];
        int c = 0;
        while ((c = is.read(bs)) > 0) {
            os.write(bs, 0, c);
        }
        os.flush();
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
        IOUtility.write(is, bos);
        return bos.toByteArray();
    }

    public static void copyFile(File f1, File f2) throws IOException {
        IOUtility.createNewFile(f2);
        FileInputStream fis = new FileInputStream(f1);
        FileOutputStream fos = new FileOutputStream(f2);
        IOUtility.write(fis, fos);
        fis.close();
        fos.close();
    }

    public static void createNewFile(File file) throws IOException {
        File parent;
        if (file.exists()) {
            file.delete();
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
    }

    public static void writeBytesToNewFile(byte[] bs, File file) throws IOException {
        IOUtility.createNewFile(file);
        FileOutputStream fos = new FileOutputStream(file);
        IOUtility.writeBytesToOs(bs, fos);
        fos.close();
    }

    public static void writeBytesToOs(byte[] bs, OutputStream os) throws IOException {
        os.write(bs);
        os.flush();
    }
}

