/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.util.IOUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class FileUtility {
    public static final int DISKFILE_OTHER = 1;
    public static final int DISKFILE_DOC = 2;
    public static final int DISKFILE_PIC = 3;
    public static final int DISKFILE_MUSIC = 4;
    public static final int DISKFILE_VIDEO = 5;
    public static final int DISKFILE_ZIP = 6;
    public static final int DISKFILE_SWF = 7;
    public static final int DISKFILE_PDF = 8;
    public static final int DISKFILE_JPG = 9;
    public static final int DISKFILE_PNG = 10;

    private FileUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean bl;
        FileInputStream input2;
        FileInputStream input1;
        block9: {
            block10: {
                boolean bl2;
                boolean file1Exists = file1.exists();
                if (file1Exists != file2.exists()) {
                    return false;
                }
                if (!file1Exists) {
                    return true;
                }
                if (file1.isDirectory() || file2.isDirectory()) {
                    return false;
                }
                input1 = null;
                input2 = null;
                try {
                    input1 = new FileInputStream(file1);
                    input2 = new FileInputStream(file2);
                    BufferedInputStream bufferedInput1 = new BufferedInputStream(input1);
                    BufferedInputStream bufferedInput2 = new BufferedInputStream(input2);
                    int ch = ((InputStream)bufferedInput1).read();
                    while (ch != -1) {
                        if (ch != ((InputStream)bufferedInput2).read()) {
                            bl = false;
                            break block9;
                        }
                        ch = ((InputStream)bufferedInput1).read();
                    }
                    if (-1 == ((InputStream)bufferedInput2).read()) break block10;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtility.shutdownStream(input1);
                    IOUtility.shutdownStream(input2);
                    throw throwable;
                }
                IOUtility.shutdownStream(input1);
                IOUtility.shutdownStream(input2);
                return bl2;
            }
            boolean bl3 = true;
            IOUtility.shutdownStream(input1);
            IOUtility.shutdownStream(input2);
            return bl3;
        }
        IOUtility.shutdownStream(input1);
        IOUtility.shutdownStream(input2);
        return bl;
    }

    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURL();
        }
        return urls;
    }

    public static String removeExtention(String filename) {
        return FileUtility.removeExtension(filename);
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removePath(String filepath) {
        return FileUtility.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getPath(String filepath) {
        return FileUtility.getPath(filepath, File.separatorChar);
    }

    public static int getFileType(String filename) {
        int type = 1;
        String suffix = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        type = suffix == null || suffix.equals("") ? 1 : (suffix.equals("doc") || suffix.equals("docx") || suffix.equals("txt") || suffix.equals("xls") || suffix.equals("xlsx") || suffix.equals("ppt") || suffix.equals("ppt") ? 2 : (suffix.equals("jpg") || suffix.equals("jpeg") || suffix.equals("bmp") || suffix.equals("gif") || suffix.equals("png") || suffix.equals("tiff") ? 3 : (suffix.equals("mp3") || suffix.equals("aac") || suffix.equals("mp2") || suffix.equals("wav") ? 4 : (suffix.equals("avi") || suffix.equals("rmvb") || suffix.equals("flv") || suffix.equals("mp4") || suffix.equals("rm") ? 5 : (suffix.equals("rar") || suffix.equals("zip") ? 6 : 1)))));
        return type;
    }

    public static int checkOfficeType(String oldfilepath) {
        String type = oldfilepath.substring(oldfilepath.lastIndexOf(".") + 1, oldfilepath.length()).toLowerCase();
        if (type.equals("doc")) {
            return 1;
        }
        if (type.equals("docx")) {
            return 1;
        }
        if (type.equals("xlsx")) {
            return 1;
        }
        if (type.equals("xls")) {
            return 1;
        }
        if (type.equals("ppt")) {
            return 1;
        }
        if (type.equals("pptx")) {
            return 1;
        }
        if (type.equals("dwg")) {
            return 1;
        }
        if (type.equals("txt")) {
            return 1;
        }
        if (type.equals("pdf")) {
            return 1;
        }
        if (type.equals("zip")) {
            return 1;
        }
        return 0;
    }

    public static int checkPictureType(String oldfilepath) {
        String type = oldfilepath.substring(oldfilepath.lastIndexOf(".") + 1, oldfilepath.length()).toLowerCase();
        if (type.equals("jpg")) {
            return 1;
        }
        if (type.equals("jpeg")) {
            return 1;
        }
        if (type.equals("bmp")) {
            return 1;
        }
        if (type.equals("gif")) {
            return 1;
        }
        if (type.equals("tif")) {
            return 1;
        }
        if (type.equals("png")) {
            return 1;
        }
        return 0;
    }

    public static int checkVideoFileType(String oldfilepath) {
        String type = oldfilepath.substring(oldfilepath.lastIndexOf(".") + 1, oldfilepath.length()).toLowerCase();
        if (type.equals("avi")) {
            return 1;
        }
        if (type.equals("mpg")) {
            return 1;
        }
        if (type.equals("wmv")) {
            return 1;
        }
        if (type.equals("3gp")) {
            return 1;
        }
        if (type.equals("mov")) {
            return 1;
        }
        if (type.equals("mp4")) {
            return 1;
        }
        if (type.equals("asf")) {
            return 1;
        }
        if (type.equals("asx")) {
            return 1;
        }
        if (type.equals("flv")) {
            return 1;
        }
        if (type.equals("mkv")) {
            return 1;
        }
        if (type.equals("wmv9")) {
            return 2;
        }
        if (type.equals("rm")) {
            return 2;
        }
        if (type.equals("rmvb")) {
            return 2;
        }
        return 0;
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtility.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        if (!source.getParentFile().equals(destinationDirectory)) {
            FileUtility.copyFile(source, new File(destinationDirectory, source.getName()));
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        IOUtility.copy((InputStream)input, (OutputStream)output);
        IOUtility.shutdownStream(input);
        IOUtility.shutdownStream(output);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtility.copy(input, (OutputStream)output);
        IOUtility.shutdownStream(input);
        IOUtility.shutdownStream(output);
    }

    public static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return new StringBuffer(lookup).append("/").append(pth).toString();
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = null;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i]);
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtility.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtility.deleteDirectory(file);
        } else if (!file.delete()) {
            String message = "File " + file + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtility.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtility.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtility.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileUtility.forceDelete(file);
        }
    }

    public static long sizeOfDirectory(String directory) {
        return FileUtility.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                size += FileUtility.sizeOfDirectory(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }

    public static File getUniquePath(String basePath, String subPath) {
        File resultPath = new File(basePath, subPath);
        int counter = 1;
        while (resultPath.exists()) {
            resultPath = new File(basePath, subPath + counter);
            ++counter;
        }
        return resultPath;
    }

    public static File getUniqueFile(String dir, String originFile) {
        String originFileName = FileUtility.removeExtension(originFile);
        String originFileExt = FileUtility.getExtension(originFile);
        File resultFile = new File(dir, originFile);
        int counter = 1;
        while (resultFile.exists()) {
            resultFile = new File(dir, new StringBuffer(originFileName).append(counter).append(".").append(originFileExt).toString());
            ++counter;
        }
        return resultFile;
    }
}

