/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.util.StringUtility;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtility {
    public static long compareDate(String sDate1, String sDate2) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = dateFormat.parse(sDate1);
            date2 = dateFormat.parse(sDate2);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in compareDate()");
            System.err.println("sDate1:" + sDate1);
            System.err.println("sDate2:" + sDate2);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return 0L;
        }
        long dif = 0L;
        long lDate2 = date2.getTime();
        long lDate1 = date1.getTime();
        dif = (lDate2 - lDate1) / 1000L / 60L / 60L / 24L;
        return dif;
    }

    public static String getCurrentDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentDay() {
        SimpleDateFormat df = new SimpleDateFormat("d");
        String day = df.format(new Date());
        return day;
    }

    public static String getCurrentMonth() {
        SimpleDateFormat df = new SimpleDateFormat("M");
        String month = df.format(new Date());
        return month;
    }

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public static String getCurrentYear() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(new Date());
    }

    public static String[] getDate(int periodType, String year, String period) {
        String[] dates = new String[]{DateUtility.getCurrentDate(), DateUtility.getCurrentDate()};
        if (periodType != 0 && periodType != 1) {
            System.err.println("Error period type in DateUtil.getDate().");
            System.err.println("Period type(0-1):" + periodType);
            return dates;
        }
        int intYear = 2000;
        try {
            intYear = Integer.parseInt(year);
            if (intYear < 1900 || intYear > 3000) {
                System.err.println("Invalid year in DateUtility.getDate().");
                System.err.println("Year(1900-3000):" + year);
                return dates;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid year in DateUtility.getDate().");
            System.err.println("Year:" + year);
            return dates;
        }
        int intPeriod = 1;
        try {
            intPeriod = Integer.parseInt(period);
            if (periodType == 0) {
                if (intPeriod < 1 || intPeriod > 4) {
                    System.err.println("Invalid season in DateUtility.getDate().");
                    System.err.println("Season(1-4):" + period);
                    return dates;
                }
            } else if (intPeriod < 1 || intPeriod > 12) {
                System.err.println("Invalid month in DateUtility.getDate().");
                System.err.println("Month(1-12):" + period);
                return dates;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid period in DateUtility.getDate().");
            System.err.println("Period:" + period);
            return dates;
        }
        if (periodType == 0) {
            switch (intPeriod) {
                case 1: {
                    dates[0] = year + "-1-1";
                    dates[1] = year + "-3-31";
                    break;
                }
                case 2: {
                    dates[0] = year + "-4-1";
                    dates[1] = year + "-6-30";
                    break;
                }
                case 3: {
                    dates[0] = year + "-7-1";
                    dates[1] = year + "-9-30";
                    break;
                }
                case 4: {
                    dates[0] = year + "-10-1";
                    dates[1] = year + "-12-31";
                }
            }
        } else {
            switch (intPeriod) {
                case 1: {
                    dates[0] = year + "-1-1";
                    dates[1] = year + "-1-31";
                    break;
                }
                case 2: {
                    dates[0] = year + "-2-1";
                    if (intYear % 400 == 0 || intYear % 4 == 0 && intYear % 100 != 0) {
                        dates[1] = year + "-2-29";
                        break;
                    }
                    dates[1] = year + "-2-28";
                    break;
                }
                case 3: {
                    dates[0] = year + "-3-1";
                    dates[1] = year + "-3-31";
                    break;
                }
                case 4: {
                    dates[0] = year + "-4-1";
                    dates[1] = year + "-4-30";
                    break;
                }
                case 5: {
                    dates[0] = year + "-5-1";
                    dates[1] = year + "-5-31";
                    break;
                }
                case 6: {
                    dates[0] = year + "-6-1";
                    dates[1] = year + "-6-30";
                    break;
                }
                case 7: {
                    dates[0] = year + "-7-1";
                    dates[1] = year + "-7-31";
                    break;
                }
                case 8: {
                    dates[0] = year + "-8-1";
                    dates[1] = year + "-8-31";
                    break;
                }
                case 9: {
                    dates[0] = year + "-9-1";
                    dates[1] = year + "-9-30";
                    break;
                }
                case 10: {
                    dates[0] = year + "-10-1";
                    dates[1] = year + "-10-31";
                    break;
                }
                case 11: {
                    dates[0] = year + "-11-1";
                    dates[1] = year + "-11-30";
                    break;
                }
                case 12: {
                    dates[0] = year + "-12-1";
                    dates[1] = year + "-12-31";
                }
            }
        }
        return dates;
    }

    public static String getDateBeforeAMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.add(5, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDateAfterAMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getFirstDateOfMonth() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-M-");
        String s = df.format(new Date());
        s = s + "1";
        return s;
    }

    public static boolean validateDate(String date, int type) {
        boolean valid = true;
        DateFormat dateFormat = DateFormat.getDateInstance();
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                date = date + "-1";
            }
        }
        try {
            dateFormat.parse(date);
        }
        catch (ParseException e) {
            valid = false;
            System.err.println("Invalid date format:" + date);
            e.printStackTrace();
        }
        return valid;
    }

    public static String getCurrentQuarter() {
        String quarter = null;
        Calendar mydate = Calendar.getInstance();
        Double dd = new Double(Math.floor(mydate.get(2) / 3));
        switch (dd.intValue()) {
            case 0: {
                quarter = "1";
                break;
            }
            case 1: {
                quarter = "2";
                break;
            }
            case 2: {
                quarter = "3";
                break;
            }
            case 3: {
                quarter = "4";
            }
        }
        return quarter;
    }

    public static String getQuarterByDay(String sDate1) {
        String quarter = "";
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date1 = null;
        try {
            date1 = dateFormat.parse(sDate1);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in getQuarterByDay()");
            System.err.println("sDate1:" + sDate1);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return "";
        }
        Calendar mydate = Calendar.getInstance();
        mydate.setTime(date1);
        Double dd = new Double(Math.floor(mydate.get(2) / 3));
        switch (dd.intValue()) {
            case 0: {
                quarter = "1";
                break;
            }
            case 1: {
                quarter = "2";
                break;
            }
            case 2: {
                quarter = "3";
                break;
            }
            case 3: {
                quarter = "4";
            }
        }
        return quarter;
    }

    public static String getDate(int dif) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, dif);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDate(String aDate, int dif) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date = null;
        try {
            date = dateFormat.parse(aDate);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in getDate()");
            System.err.println("aDate:" + aDate);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dif);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDateBeforeAMonth(String aDate) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date1 = null;
        try {
            date1 = dateFormat.parse(aDate);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in getDateBeforeAMonth(String)");
            System.err.println("aDate:" + aDate);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        calendar.add(2, -1);
        calendar.add(5, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDateAfterMonth(String aDate) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date1 = null;
        try {
            date1 = dateFormat.parse(aDate);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in getDateBeforeAMonth(String)");
            System.err.println("aDate:" + aDate);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        calendar.add(2, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDateAfterMonth(String aDate, int n) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date date1 = null;
        try {
            date1 = dateFormat.parse(aDate);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in getDateBeforeAMonth(String)");
            System.err.println("aDate:" + aDate);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        calendar.add(2, 1);
        calendar.set(5, n);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static int getLastDate(String selectDate) {
        int dates = 0;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(DateFormat.getDateInstance().parse(selectDate));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        int year = calendar.get(1);
        System.out.println(calendar.get(2));
        switch (calendar.get(2) + 1) {
            case 1: {
                dates = 31;
                break;
            }
            case 2: {
                if (year % 400 == 0 || year % 4 == 0 && year % 100 != 0) {
                    dates = 29;
                    break;
                }
                dates = 28;
                break;
            }
            case 3: {
                dates = 31;
                break;
            }
            case 4: {
                dates = 30;
                break;
            }
            case 5: {
                dates = 31;
                break;
            }
            case 6: {
                dates = 30;
                break;
            }
            case 7: {
                dates = 31;
                break;
            }
            case 8: {
                dates = 31;
                break;
            }
            case 9: {
                dates = 30;
                break;
            }
            case 10: {
                dates = 31;
                break;
            }
            case 11: {
                dates = 30;
                break;
            }
            case 12: {
                dates = 31;
            }
        }
        return dates;
    }

    public static String getNextDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-M-d");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getPreviousDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-M-d");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String changeDateFormat(String oldValue) {
        String newValue = new String("2000.01.01");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        DateFormat df = DateFormat.getDateInstance();
        Date temp = null;
        try {
            temp = df.parse(oldValue);
        }
        catch (ParseException e) {
            System.err.println("Catch invalid date format in method changeDateFormat(String oldValue) in class DateUtility.");
            System.err.println("Your input parameter:oldValue(" + oldValue + ")");
        }
        newValue = sdf.format(temp);
        return newValue;
    }

    public static java.sql.Date constructDate(String aDay, String aHour, String aMinute, String aSecond) {
        int second;
        int minute;
        int hour;
        java.sql.Date sDate = null;
        Date uDate = null;
        DateFormat dateFormat = DateFormat.getDateInstance();
        try {
            uDate = dateFormat.parse(aDay);
            hour = Integer.parseInt(aHour);
            minute = Integer.parseInt(aMinute);
            second = Integer.parseInt(aSecond);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println("aDay:" + aDay);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (NumberFormatException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(uDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        uDate = calendar.getTime();
        sDate = new java.sql.Date(uDate.getTime());
        return sDate;
    }

    public static java.sql.Date constructDate(String aDay) {
        return DateUtility.constructDate(aDay, "0", "0", "0");
    }

    public static Timestamp constructTimestamp(String aDay, String aHour, String aMinute, String aSecond) {
        int second;
        int minute;
        int hour;
        Timestamp timestamp = null;
        Date uDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            uDate = sdf.parse(aDay);
            hour = Integer.parseInt(aHour);
            minute = Integer.parseInt(aMinute);
            second = Integer.parseInt(aSecond);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println("aDay:" + aDay);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (NumberFormatException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(uDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        uDate = calendar.getTime();
        timestamp = new Timestamp(uDate.getTime());
        return timestamp;
    }

    public static Timestamp constructTimestamp(String aTime) {
        int second;
        int minute;
        int hour;
        Timestamp timestamp = null;
        if (aTime.indexOf(":") == -1) {
            return DateUtility.constructTimestamp(aTime, "0", "0", "0");
        }
        Date uDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dateFormat = DateFormat.getDateInstance();
        try {
            String[] aDate1 = StringUtility.split(aTime, " ");
            String[] aDate2 = StringUtility.split(aDate1[1], ":");
            uDate = sdf.parse(aDate1[0]);
            hour = Integer.parseInt(aDate2[0]);
            minute = Integer.parseInt(aDate2[1]);
            second = Integer.parseInt(aDate2[2]);
        }
        catch (ParseException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println("aTime:" + aTime);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (NumberFormatException e) {
            System.err.println("Application log:Catch Exception in DateUtility");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(uDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        uDate = calendar.getTime();
        timestamp = new Timestamp(uDate.getTime());
        return timestamp;
    }

    public static String getFirstDateOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-");
        String s = df.format(calendar.getTime());
        s = s + "01";
        return s;
    }

    public static String getLastDateOfLastMonth() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date uDate = null;
        try {
            uDate = dateFormat.parse(DateUtility.getFirstDateOfMonth());
        }
        catch (ParseException e) {
            System.err.println("Application log: Catch Exception in DateUtility");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(uDate);
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String[] getSameOfLastYear(String curBegin, String curEnd) {
        String[] last = new String[]{Integer.parseInt(curBegin.substring(0, 4)) - 1 + curBegin.substring(4), Integer.parseInt(curEnd.substring(0, 4)) - 1 + curEnd.substring(4)};
        return last;
    }

    public static String formatDate(Date aDate, String formatString) {
        if (aDate == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        SimpleDateFormat df = new SimpleDateFormat(formatString);
        String s = df.format(calendar.getTime());
        return s;
    }

    public static String getDay(String s) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dayFormatter = new SimpleDateFormat("EEE");
        ParsePosition pos = new ParsePosition(0);
        Date giveDate = dateFormatter.parse(s, pos);
        return dayFormatter.format(giveDate).toString();
    }

    public static Date getDate(String s) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        if (s.indexOf(":") > -1) {
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        if (s.indexOf("+") > -1) {
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        }
        ParsePosition pos = new ParsePosition(0);
        return dateFormatter.parse(s, pos);
    }

    public static Date getDayD(String s) {
        SimpleDateFormat dayFormatter = new SimpleDateFormat("EEE");
        ParsePosition pos = new ParsePosition(0);
        return dayFormatter.parse(s, pos);
    }

    public static Date getTimeD(String s) {
        SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        return timeFormatter.parse(s, pos);
    }

    public static Integer getWeekOfDate(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    public static void main(String[] args) throws ParseException {
        for (int k = 0; k < 7; ++k) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, k);
            String year = DateUtility.getCurrentYear();
            SimpleDateFormat dff = new SimpleDateFormat("yyyy-MM-dd");
            String s = year + "-01-01";
            Long l = dff.parse(s).getTime() - System.currentTimeMillis();
        }
    }
}

