/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.logging.ChromeProxy;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.IOUtility;
import com.ds.common.util.java.DynamicClassLoader;
import com.ds.common.util.java.TmpJavaFileManager;
import com.ds.common.util.java.TmpJavaFileObject;
import com.ds.config.JDSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class CompileJava {
    public static boolean compile(Set<File> list, Set<String> libPaths, Set<String> classPaths, ChromeProxy log) throws IOException {
        String libPath = JDSUtil.getJdsRealPath() + "lib";
        String dest = JDSUtil.getJdsRealPath() + "classes";
        if (libPaths == null) {
            libPaths = new HashSet<String>();
        }
        libPaths.add(new File(libPath).getAbsolutePath());
        libPaths.add(new File(dest).getAbsolutePath());
        return CompileJava.compile(list, dest, libPaths, classPaths, log);
    }

    public static boolean compile(File file, Set<String> classPaths, ChromeProxy log) throws IOException {
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        list.add(file);
        return CompileJava.compile(list, null, classPaths, log);
    }

    public static boolean compile(File file, Set<String> libPaths, Set<String> classPaths, ChromeProxy log) throws IOException {
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        list.add(file);
        return CompileJava.compile(list, libPaths, classPaths, log);
    }

    private static boolean compile(Set<File> javaFiles, String des, Set<String> libPaths, Set<String> classSrcPaths, ChromeProxy log) throws IOException {
        JavaFileObject fileObject;
        String classpath = CompileJava.getLibPathFromDirs(libPaths);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            log.printError("\u6ca1\u6709\u7f16\u8bd1\u5668,\u4e0d\u80fd\u7f16\u8bd1");
            throw new RuntimeException("\u6ca1\u6709\u7f16\u8bd1\u5668,\u4e0d\u80fd\u7f16\u8bd1");
        }
        File dir = new File(des);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("-d");
        optionList.add(dir.getCanonicalPath());
        optionList.add("-parameters");
        if (classpath != null) {
            optionList.add("-classpath");
            classpath = ".;" + CompileJava.getAbsolutePath("") + ";" + classpath + dir.getCanonicalPath() + File.separator;
            for (String string : classSrcPaths) {
                File file = new File(string);
                if (!file.exists()) continue;
                classpath = classpath + ";" + file.getCanonicalPath() + File.separator;
            }
            optionList.add(classpath);
        }
        ArrayList<TmpJavaFileObject> files = new ArrayList<TmpJavaFileObject>();
        for (File javaFile : javaFiles) {
            if (!javaFile.exists()) continue;
            String fileName = javaFile.getName();
            fileName = fileName.substring(0, fileName.length() - ".java".length());
            FileInputStream inputStream = new FileInputStream(javaFile);
            String string = IOUtility.toString(inputStream);
            IOUtility.shutdownStream(inputStream);
            fileObject = new TmpJavaFileObject(fileName, string);
            files.add((TmpJavaFileObject)fileObject);
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        TmpJavaFileManager javaFileManager = new TmpJavaFileManager(javaCompiler.getStandardFileManager(diagnosticCollector, null, null));
        if (!javaCompiler.getTask(null, javaFileManager, diagnosticCollector, optionList, null, files).call().booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
                fileObject = (JavaFileObject)diagnostic.getSource();
                String err = String.format("Compilation error: Line %d - %s%n", diagnostic.getLineNumber(), diagnostic.getMessage(null));
                if (fileObject != null) {
                    String fileName = fileObject.getName();
                    String fileNameBuff = "\u7f16\u8bd1 \u51fa\u9519\uff1a" + fileName;
                    err = fileNameBuff + System.lineSeparator() + err;
                }
                errorMsg.append(err);
                System.err.print(err);
            }
            javaFileManager.close();
            javaFileManager.flush();
            throw new IOException(errorMsg.toString());
        }
        ArrayList classes = new ArrayList();
        Map<String, JavaFileObject> fileObjectMap = javaFileManager.getFileObjectMap();
        ClassUtility.getFileObjectMap().putAll(fileObjectMap);
        for (Map.Entry<String, JavaFileObject> entry : fileObjectMap.entrySet()) {
            String className = entry.getKey();
            TmpJavaFileObject bytesJavaFileObject = (TmpJavaFileObject)entry.getValue();
            DynamicClassLoader loader = ClassUtility.getDynamicClassLoader(className, bytesJavaFileObject, true);
            Class<?> clazz = null;
            try {
                clazz = loader.findClass(entry.getKey());
            }
            catch (ClassNotFoundException e) {
                loader = ClassUtility.getDynamicClassLoader(className, bytesJavaFileObject, true);
                try {
                    clazz = loader.findClass(entry.getKey());
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            if (clazz == null) continue;
            classes.add(clazz);
            ClassUtility.dynClassMap.put(className, clazz);
            TypeUtils.addMapping((String)className, clazz);
        }
        javaFileManager.close();
        javaFileManager.flush();
        return true;
    }

    public static boolean compile(String src, Set<String> paths, ChromeProxy chrome) throws IOException {
        File srcFile = new File(src);
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        CompileJava.getAllJavaFile(srcFile, list);
        return CompileJava.compile(list, null, paths, chrome);
    }

    public static Class dynCompile(String className, String classCode, String desc) throws IOException, ClassNotFoundException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        ArrayList<TmpJavaFileObject> fileObjects = new ArrayList<TmpJavaFileObject>();
        String simpleName = className;
        if (simpleName.indexOf(".") > -1) {
            simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        TmpJavaFileObject sourceJavaFileObject = new TmpJavaFileObject(simpleName, classCode);
        fileObjects.add(sourceJavaFileObject);
        String libPath = JDSUtil.getJdsRealPath() + "lib";
        String dest = JDSUtil.getJdsRealPath() + "classes";
        HashSet<String> paths = new HashSet<String>();
        paths.add(libPath);
        paths.add(dest);
        String classpath = CompileJava.getLibPathFromDirs(paths);
        ArrayList<String> optionList = new ArrayList<String>();
        File dir = new File(desc);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        optionList.add("-d");
        optionList.add(dir.getCanonicalPath());
        optionList.add("-parameters");
        optionList.add("-classpath");
        classpath = ".;" + CompileJava.getAbsolutePath("") + ";" + classpath + dir.getCanonicalPath() + "/;" + desc;
        optionList.add(classpath);
        DiagnosticCollector collector = new DiagnosticCollector();
        TmpJavaFileManager javaFileManager = new TmpJavaFileManager(javaCompiler.getStandardFileManager(collector, null, null));
        if (!javaCompiler.getTask(null, javaFileManager, collector, optionList, null, fileObjects).call().booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            for (Diagnostic d : collector.getDiagnostics()) {
                String err = String.format("Compilation error: Line %d - %s%n", d.getLineNumber(), d.getMessage(null));
                errorMsg.append(err);
                System.err.print(err);
            }
            throw new IOException(errorMsg.toString());
        }
        TmpJavaFileObject bytesJavaFileObject = (TmpJavaFileObject)javaFileManager.getFileObjectMap().get(className);
        if (bytesJavaFileObject != null) {
            sourceJavaFileObject = bytesJavaFileObject;
        }
        ClassUtility.getFileObjectMap().put(className, sourceJavaFileObject);
        DynamicClassLoader loader = ClassUtility.getDynamicClassLoader(className, sourceJavaFileObject, true);
        Class<?> clazz = loader.findClass(className);
        ClassUtility.getDynClassMap().put(className, clazz);
        TypeUtils.addMapping((String)className, clazz);
        return clazz;
    }

    public static boolean compile(String src, Set<String> paths, Set<String> classPaths, ChromeProxy chrome) throws IOException {
        File srcFile = new File(src);
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        CompileJava.getAllJavaFile(srcFile, list);
        return CompileJava.compile(list, paths, classPaths, chrome);
    }

    public static Set<File> getAllJavaFile(File srcFile) {
        return CompileJava.getAllJavaFile(srcFile, null);
    }

    private static Set<File> getAllJavaFile(File srcFile, Set<File> list) {
        if (list == null) {
            list = new LinkedHashSet<File>();
        }
        if (srcFile.isDirectory()) {
            File[] fs = srcFile.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                CompileJava.getAllJavaFile(fs[i], list);
            }
        } else if (srcFile.getName().endsWith(".java")) {
            list.add(srcFile);
        }
        return list;
    }

    private static void getLibPathFromDir(File dir, StringBuilder sb) throws IOException {
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                CompileJava.getLibPathFromDir(fs[i], sb);
            }
        } else if (dir.getName().endsWith(".jar")) {
            sb.append(dir.getCanonicalPath());
            sb.append(";");
        }
    }

    private static String getLibPathFromDirs(Set<String> dir) throws IOException {
        if (dir == null || dir.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String path : dir) {
            File d;
            if (path == null || !(d = new File(path)).isDirectory()) continue;
            CompileJava.getLibPathFromDir(d, sb);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
    }

    public static String getAbsolutePath(String relativePath) {
        try {
            return Thread.currentThread().getContextClassLoader().getResource(relativePath).toURI().getPath();
        }
        catch (URISyntaxException e) {
            return Thread.currentThread().getContextClassLoader().getResource(relativePath).getPath();
        }
    }
}

