/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.util.FileClassLoader;
import com.ds.common.util.java.DynamicClassLoader;
import com.ds.common.util.java.TmpJavaFileObject;
import com.ds.esb.config.manager.EsbBeanFactory;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.JavaFileObject;

public final class ClassUtility {
    private static ClassUtility instance = new ClassUtility();
    public static Map<String, Class<?>> dynClassMap = new ConcurrentHashMap();
    public static Map<String, Class<?>> fileClassMap = new ConcurrentHashMap();
    private static Map<String, JavaFileObject> fileObjectMap = new ConcurrentHashMap<String, JavaFileObject>();
    public static Map<String, DynamicClassLoader> classLoaderMap = new ConcurrentHashMap<String, DynamicClassLoader>();

    private ClassUtility() {
    }

    public static synchronized DynamicClassLoader getDynamicClassLoader(String className, TmpJavaFileObject fileObject, Boolean dyn) {
        DynamicClassLoader loader = classLoaderMap.get(className);
        if (loader == null || dyn.booleanValue()) {
            loader = new DynamicClassLoader(fileObject);
            classLoaderMap.put(className, loader);
        } else {
            loader.setTmpJavaFileObject(fileObject);
        }
        return loader;
    }

    public static synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("char")) {
            return Character.class;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        Class<?> theClass = fileClassMap.get(className);
        if (theClass == null) {
            theClass = dynClassMap.get(className);
            TmpJavaFileObject fileObject = (TmpJavaFileObject)fileObjectMap.get(className);
            if (theClass == null && fileObject != null) {
                DynamicClassLoader loader = ClassUtility.getDynamicClassLoader(className, fileObject, true);
                try {
                    theClass = loader.findClass(className);
                    dynClassMap.put(className, theClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (theClass == null) {
            theClass = EsbBeanFactory.findClass(className);
        }
        if (theClass == null) {
            try {
                theClass = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                try {
                    theClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e2) {
                    theClass = instance.getClass().getClassLoader().loadClass(className);
                }
            }
        }
        return theClass;
    }

    public static Class loadClassByFile(String classPath, String className) throws ClassNotFoundException {
        FileClassLoader classLoader = new FileClassLoader(classPath);
        Class theClass = classLoader.findClass(className);
        fileClassMap.put(className, theClass);
        return theClass;
    }

    public static InputStream loadResource(String name) {
        InputStream in = instance.getClass().getResourceAsStream(name);
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
            in = instance.getClass().getClassLoader().getResourceAsStream(name);
        }
        return in;
    }

    public static URL loadResourceURL(String name) {
        URL url = instance.getClass().getResource(name);
        if (url == null && (url = Thread.currentThread().getContextClassLoader().getResource(name)) == null) {
            url = instance.getClass().getClassLoader().getResource(name);
        }
        return url;
    }

    public static void clear(String className) {
        dynClassMap.remove(className);
        fileObjectMap.remove(className);
        classLoaderMap.remove(className);
    }

    public static Set<Package> getAllDynPacks() {
        HashSet<Package> packages = new HashSet<Package>();
        Set<String> keySet = dynClassMap.keySet();
        for (String key : keySet) {
            Class<?> clazz = dynClassMap.get(key);
            packages.add(clazz.getPackage());
        }
        return packages;
    }

    public static Map<String, Class<?>> getDynClassMap() {
        return dynClassMap;
    }

    public static void setDynClassMap(Map<String, Class<?>> dynClassMap) {
        ClassUtility.dynClassMap = dynClassMap;
    }

    public static Map<String, JavaFileObject> getFileObjectMap() {
        return fileObjectMap;
    }

    public static void setFileObjectMap(Map<String, JavaFileObject> fileObjectMap) {
        ClassUtility.fileObjectMap = fileObjectMap;
    }
}

