/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.query;

import com.ds.common.query.ConditionKey;
import com.ds.common.query.Filter;
import com.ds.common.query.JLuceneIndex;
import com.ds.common.query.JoinOperator;
import com.ds.common.query.Operator;
import com.ds.common.query.Order;
import com.ds.common.query.Page;
import com.ds.common.util.StringUtility;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Condition<T extends ConditionKey, V extends JLuceneIndex>
implements Serializable,
Filter {
    V index;
    protected T conditionKey;
    protected Object value;
    protected Operator operator;
    public Page page;
    protected List<Condition<T, V>> childConditionList;
    protected List<JoinOperator> childJoinTypeList;
    protected List<Order<T>> orderByList = new ArrayList<Order<T>>();

    public Condition() {
        this.childConditionList = new ArrayList<Condition<T, V>>();
        this.childJoinTypeList = new ArrayList<JoinOperator>();
        this.orderByList = new ArrayList<Order<T>>();
        this.page = new Page();
    }

    public V getIndex() {
        return this.index;
    }

    public void setIndex(V index) {
        this.index = index;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Condition(T conditionKey, V index, Operator operator) {
        this(conditionKey, index, operator, null);
    }

    public Condition(T conditionKey, Operator operator) {
        this(conditionKey, null, operator, null);
    }

    public T getConditionKey() {
        return this.conditionKey;
    }

    public void setConditionKey(T conditionKey) {
        this.conditionKey = conditionKey;
    }

    public Condition(T conditionKey, V index, Operator operator, Object value) {
        this();
        this.index = index;
        this.conditionKey = conditionKey;
        this.value = value;
        this.operator = operator;
    }

    public Condition(T conditionKey, Operator operator, Object value) {
        this(conditionKey, null, operator, value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<Condition<T, V>> getChildConditionList() {
        return this.childConditionList;
    }

    public void setChildConditionList(List<Condition<T, V>> childConditionList) {
        this.childConditionList = childConditionList;
    }

    public List<JoinOperator> getChildJoinTypeList() {
        return this.childJoinTypeList;
    }

    public void setChildJoinTypeList(List<JoinOperator> childJoinTypeList) {
        this.childJoinTypeList = childJoinTypeList;
    }

    public List<Order<T>> getOrderByList() {
        return this.orderByList;
    }

    public void setOrderByList(List<Order<T>> orderByList) {
        this.orderByList = orderByList;
    }

    public String makeConditionString() {
        String childCondition;
        String whereStr = "";
        if (this.value != null) {
            switch (this.operator) {
                case EQUALS: {
                    whereStr = this.conditionKey.getValue() + " = " + this.extractValue(this.value);
                    break;
                }
                case NOT_EQUAL: {
                    whereStr = this.conditionKey.getValue() + " != " + this.extractValue(this.value);
                    break;
                }
                case LESS_THAN: {
                    whereStr = this.conditionKey.getValue() + " < " + this.extractValue(this.value);
                    break;
                }
                case GREATER_THAN: {
                    whereStr = this.conditionKey.getValue() + " > " + this.extractValue(this.value);
                    break;
                }
                case LESS_THAN_EQUAL_TO: {
                    whereStr = this.conditionKey.getValue() + " <= " + this.extractValue(this.value);
                    break;
                }
                case GREATER_THAN_EQUAL_TO: {
                    whereStr = this.conditionKey.getValue() + " >= " + this.extractValue(this.value);
                    break;
                }
                case LIKE: {
                    whereStr = this.conditionKey.getValue() + " LIKE " + this.extractValue(this.value);
                    break;
                }
                case IN: {
                    Iterator ite;
                    StringBuffer sb = new StringBuffer();
                    if (this.value instanceof Collection) {
                        ite = ((Collection)this.value).iterator();
                        boolean first = true;
                        while (ite.hasNext()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(",");
                            }
                            sb.append(this.extractValue(ite.next()));
                        }
                    } else if (this.value instanceof String) {
                        sb.append((String)this.value);
                    }
                    if (sb.length() <= 0) break;
                    whereStr = this.conditionKey.getValue() + " IN (" + sb.toString() + ")";
                    break;
                }
                case NOT_IN: {
                    Iterator ite;
                    StringBuffer sb = new StringBuffer();
                    if (this.value instanceof Collection) {
                        ite = ((Collection)this.value).iterator();
                        boolean first = true;
                        while (ite.hasNext()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(",");
                            }
                            sb.append(this.extractValue(ite.next()));
                        }
                    } else if (this.value instanceof String) {
                        sb.append((String)this.value);
                    }
                    if (sb.length() <= 0) break;
                    whereStr = this.conditionKey.getValue() + " NOT IN (" + sb.toString() + ")";
                    break;
                }
                case BETWEEN: {
                    Collection valueCol;
                    if (!(this.value instanceof Collection) || (valueCol = (Collection)this.value).size() < 2) break;
                    whereStr = this.conditionKey.getValue() + " BETWEEN ";
                    Iterator ite = valueCol.iterator();
                    if (ite.hasNext()) {
                        whereStr = whereStr + this.extractValue(ite.next());
                    }
                    whereStr = whereStr + " AND ";
                    if (!ite.hasNext()) break;
                    whereStr = whereStr + this.extractValue(ite.next());
                    break;
                }
                case NULL: {
                    whereStr = this.conditionKey.getValue() + " IS NULL";
                    break;
                }
                case NOT_NULL: {
                    whereStr = this.conditionKey.getValue() + " IS NOT NULL";
                }
            }
        }
        if (!"".equals(childCondition = this.makeChildrenCondition())) {
            if (!"".equals(whereStr)) {
                JoinOperator joinType = this.childJoinTypeList.get(0);
                switch (joinType) {
                    case JOIN_AND: {
                        whereStr = whereStr + " AND ";
                        break;
                    }
                    case JOIN_OR: {
                        whereStr = whereStr + " OR ";
                    }
                }
            }
            whereStr = whereStr + childCondition;
        }
        if (!"".equals(whereStr)) {
            whereStr = whereStr + this.makeOrderBy();
        }
        return whereStr;
    }

    public void addOrderBy(Order<T> order) {
        this.orderByList.add(order);
    }

    public void addCondition(Condition<T, V> condition, JoinOperator joinType) {
        if (condition != null) {
            if (joinType.equals((Object)JoinOperator.JOIN_AND) && joinType.equals((Object)JoinOperator.JOIN_OR)) {
                throw new IllegalArgumentException("Parameter joinType must be JOIN_AND or JOIN_OR.");
            }
            if (condition.orderByList.size() != 0) {
                throw new IllegalArgumentException("Parameter condition contains order by and cannot be child conditon.");
            }
            this.childConditionList.add(condition);
            this.childJoinTypeList.add(joinType);
        }
    }

    private String makeChildrenCondition() {
        String result = "";
        if (this.childConditionList.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.childConditionList.size(); ++i) {
                Condition<T, V> condition = this.childConditionList.get(i);
                if ("".equals(condition.makeConditionString())) continue;
                JoinOperator joinType = this.childJoinTypeList.get(i);
                if (i != 0) {
                    switch (joinType) {
                        case JOIN_AND: {
                            buf.append(" AND ");
                            break;
                        }
                        case JOIN_OR: {
                            buf.append(" OR ");
                        }
                    }
                }
                buf.append(condition.makeConditionString());
            }
            String tmp = buf.toString();
            if (!"".equals(tmp)) {
                buf.insert(0, "(");
                buf.append(")");
            }
            result = buf.toString();
        }
        return result;
    }

    private String makeOrderBy() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.orderByList.size(); ++i) {
            Order<T> order = this.orderByList.get(i);
            if (i == 0) {
                buf.append(" ORDER BY ");
            } else {
                buf.append(",");
            }
            buf.append(order.toString());
        }
        return buf.toString();
    }

    public String extractValue(Object value) {
        if (value instanceof Enum) {
            return "'" + StringUtility.replace(((Enum)value).toString(), "'", "''") + "'";
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof String) {
            return "'" + StringUtility.replace((String)value, "'", "''") + "'";
        }
        if (value instanceof Date) {
            return String.valueOf(((Date)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return String.valueOf(((java.util.Date)value).getTime());
        }
        return value.toString();
    }

    @Override
    public boolean filterObject(Object obj, String systemCode) {
        return true;
    }

    public static void main(String[] args) {
    }
}

