/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.property;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.property.PropertyResourceBundle;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Vector;

public abstract class ResourceBundle {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Random RANDOM = new Random();
    private static final Hashtable underConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEFAULT_NOT_FOUND = new Integer(-1);
    private static Cache cacheList = CacheManagerFactory.createCache("System", "ResourceBundle");
    protected ResourceBundle parent = null;
    private Locale locale = null;

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) throws MissingResourceException {
        try {
            return this.getBoolean(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) throws MissingResourceException {
        String value = this.getString(key);
        return value.equalsIgnoreCase("true");
    }

    public byte getByte(String key, byte defaultValue) throws MissingResourceException {
        try {
            return this.getByte(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public byte getByte(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a byte value but got " + value, "java.lang.String", key);
        }
    }

    public char getChar(String key, char defaultValue) throws MissingResourceException {
        try {
            return this.getChar(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public char getChar(String key) throws MissingResourceException {
        String value = this.getString(key);
        if (1 == value.length()) {
            return value.charAt(0);
        }
        throw new MissingResourceException("Expecting a char value but got " + value, "java.lang.String", key);
    }

    public short getShort(String key, short defaultValue) throws MissingResourceException {
        try {
            return this.getShort(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public short getShort(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a short value but got " + value, "java.lang.String", key);
        }
    }

    public int getInteger(String key, int defaultValue) throws MissingResourceException {
        try {
            return this.getInteger(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public int getInteger(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a integer value but got " + value, "java.lang.String", key);
        }
    }

    public long getLong(String key, long defaultValue) throws MissingResourceException {
        try {
            return this.getLong(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public long getLong(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a long value but got " + value, "java.lang.String", key);
        }
    }

    public float getFloat(String key, float defaultValue) throws MissingResourceException {
        try {
            return this.getFloat(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public float getFloat(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a float value but got " + value, "java.lang.String", key);
        }
    }

    public double getDouble(String key, double defaultValue) throws MissingResourceException {
        try {
            return this.getDouble(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public double getDouble(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a double value but got " + value, "java.lang.String", key);
        }
    }

    public Date getDate(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getDate(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getDate(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            DateFormat format = DateFormat.getDateInstance(2, this.getLocale());
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a date value but got " + value, "java.lang.String", key);
        }
    }

    public Date getTime(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getTime(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getTime(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            DateFormat format = DateFormat.getTimeInstance(2, this.getLocale());
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a time value but got " + value, "java.lang.String", key);
        }
    }

    public Date getDateTime(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getDateTime(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getDateTime(String key) throws MissingResourceException {
        String value = this.getString(key);
        try {
            DateFormat format = DateFormat.getDateTimeInstance(2, 2, this.getLocale());
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a time value but got " + value, "java.lang.String", key);
        }
    }

    public String getString(String key, Object arg1) {
        Object[] args = new Object[]{arg1};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return this.format(key, args);
    }

    public String format(String key, Object[] args) {
        try {
            String pattern = this.getPatternString(key);
            return MessageFormat.format(pattern, args);
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unknown resource. Key: '");
            sb.append(key);
            sb.append("' Args: '");
            for (int i = 0; i < args.length; ++i) {
                if (0 != i) {
                    sb.append("', '");
                }
                sb.append(args[i]);
            }
            sb.append("' Reason: ");
            sb.append(mre);
            return sb.toString();
        }
    }

    private String getPatternString(String key) throws MissingResourceException {
        Object object = this.getObject(key);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] strings = (String[])object;
            return strings[RANDOM.nextInt(strings.length)];
        }
        throw new MissingResourceException("Unable to find resource of appropriate type.", "java.lang.String", key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        Object obj = this.handleGetObject(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(String baseName, String bundleName) {
        if (baseName.length() == bundleName.length()) {
            this.locale = new Locale("", "");
        } else if (baseName.length() < bundleName.length()) {
            int pos = baseName.length();
            String temp = bundleName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                this.locale = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            this.locale = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static ClassLoader getLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundleImpl(baseName, Locale.getDefault(), ResourceBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundleImpl(baseName, locale, ResourceBundle.getLoader());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(baseName, locale, loader);
    }

    private static ResourceBundle getBundleImpl(String baseName, Locale locale, ClassLoader loader) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        Object NOTFOUND = loader != null ? loader : DEFAULT_NOT_FOUND;
        String bundleName = baseName;
        String localeSuffix = locale.toString();
        if (localeSuffix.length() > 0) {
            bundleName = bundleName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            bundleName = bundleName + "___" + locale.getVariant();
        }
        Locale defaultLocale = locale;
        Object lookup = ResourceBundle.findBundleInCache(loader, bundleName, defaultLocale);
        if (lookup == NOTFOUND) {
            ResourceBundle.throwMissingResourceException(baseName, locale);
        } else if (lookup != null) {
            return (ResourceBundle)lookup;
        }
        Object parent = NOTFOUND;
        try {
            boolean foundInMainBranch;
            Object root = ResourceBundle.findBundle(loader, baseName, defaultLocale, baseName, null, NOTFOUND);
            if (root == null) {
                ResourceBundle.putBundleInCache(loader, baseName, defaultLocale, NOTFOUND);
                root = NOTFOUND;
            }
            Vector names = ResourceBundle.calculateBundleNames(baseName, locale);
            Vector<Object> bundlesFound = new Vector<Object>(3);
            boolean bl = foundInMainBranch = root != NOTFOUND && names.size() == 0;
            if (!foundInMainBranch) {
                parent = root;
                for (int i = 0; i < names.size(); ++i) {
                    bundleName = (String)names.elementAt(i);
                    lookup = ResourceBundle.findBundle(loader, bundleName, defaultLocale, baseName, parent, NOTFOUND);
                    bundlesFound.addElement(lookup);
                    if (lookup == null) continue;
                    parent = lookup;
                    foundInMainBranch = true;
                }
            }
            parent = root;
            if (!foundInMainBranch) {
                Vector fallbackNames = ResourceBundle.calculateBundleNames(baseName, defaultLocale);
                for (int i = 0; i < fallbackNames.size() && !names.contains(bundleName = (String)fallbackNames.elementAt(i)); ++i) {
                    lookup = ResourceBundle.findBundle(loader, bundleName, defaultLocale, baseName, parent, NOTFOUND);
                    if (lookup != null) {
                        parent = lookup;
                        continue;
                    }
                    ResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, parent);
                }
            }
            parent = ResourceBundle.propagate(loader, names, bundlesFound, defaultLocale, parent);
        }
        catch (Exception e) {
            ResourceBundle.cleanUpConstructionList();
            ResourceBundle.throwMissingResourceException(baseName, locale);
        }
        catch (Error e) {
            ResourceBundle.cleanUpConstructionList();
            throw e;
        }
        if (parent == NOTFOUND) {
            ResourceBundle.throwMissingResourceException(baseName, locale);
        }
        return (ResourceBundle)parent;
    }

    private static Object propagate(ClassLoader loader, Vector names, Vector bundlesFound, Locale defaultLocale, Object parent) {
        for (int i = 0; i < names.size(); ++i) {
            String bundleName = (String)names.elementAt(i);
            Object lookup = bundlesFound.elementAt(i);
            if (lookup == null) {
                ResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, parent);
                continue;
            }
            parent = lookup;
        }
        return parent;
    }

    private static void throwMissingResourceException(String baseName, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        Cache cache = cacheList;
        synchronized (cache) {
            Collection entries = underConstruction.values();
            Thread thisThread = Thread.currentThread();
            while (entries.remove(thisThread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader loader, String bundleName, Locale defaultLocale, String baseName, Object parent, Object NOTFOUND) {
        Object builder;
        Object result;
        Cache cache = cacheList;
        synchronized (cache) {
            boolean beingBuilt;
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            result = cacheList.get(cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            builder = (Thread)underConstruction.get(cacheKey);
            boolean bl = beingBuilt = builder != null && builder != Thread.currentThread();
            if (beingBuilt) {
                while (beingBuilt) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(loader, bundleName, defaultLocale);
                    beingBuilt = underConstruction.containsKey(cacheKey);
                }
                result = cacheList.get(cacheKey);
                if (result != null) {
                    cacheKey.clear();
                    return result;
                }
            }
            Object key = cacheKey.clone();
            underConstruction.put(key, Thread.currentThread());
            cacheKey.clear();
        }
        result = ResourceBundle.loadBundle(loader, bundleName, defaultLocale);
        if (result != null) {
            boolean constructing;
            builder = cacheList;
            synchronized (builder) {
                cacheKey.setKeyValues(loader, bundleName, defaultLocale);
                constructing = underConstruction.get(cacheKey) == Thread.currentThread();
                cacheKey.clear();
            }
            if (constructing) {
                ResourceBundle bundle = (ResourceBundle)result;
                if (parent != NOTFOUND && bundle.parent == null) {
                    bundle.setParent((ResourceBundle)parent);
                }
                bundle.setLocale(baseName, bundleName);
                ResourceBundle.putBundleInCache(loader, bundleName, defaultLocale, result);
            }
        }
        return result;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader loader, String bundleName, Locale defaultLocale) {
        Cache cache = cacheList;
        synchronized (cache) {
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            Object result = cacheList.get(cacheKey);
            cacheKey.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader loader, String bundleName, Locale defaultLocale, Object value) {
        Cache cache = cacheList;
        synchronized (cache) {
            cacheKey.setKeyValues(loader, bundleName, defaultLocale);
            cacheList.put(cacheKey.clone(), value);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadBundle(final ClassLoader loader, String bundleName, Locale defaultLocale) {
        try {
            Class<?> bundleClass = loader != null ? loader.loadClass(bundleName) : Class.forName(bundleName);
            if (ResourceBundle.class.isAssignableFrom(bundleClass)) {
                Object myBundle = bundleClass.newInstance();
                Object otherBundle = ResourceBundle.findBundleInCache(loader, bundleName, defaultLocale);
                if (otherBundle != null) {
                    return otherBundle;
                }
                return myBundle;
            }
        }
        catch (Exception bundleClass) {
        }
        catch (LinkageError bundleClass) {
            // empty catch block
        }
        final String resName = bundleName.replace('.', '/') + ".properties";
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            }
        });
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                return propertyResourceBundle;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration getKeys();

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader loader, String searchName, Locale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (loader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(loader);
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

