/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.md5;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TOTP {
    private static final String SECRET_KEY = "ga35sdia43dhqj6k3f0la";
    private static final long STEP = 3000L;
    private static final int CODE_DIGITS = 6;
    private static final long INITIAL_TIME = 0L;
    private static final long FLEXIBILIT_TIME = 5000L;
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    public static void main(String[] args) {
        try {
            for (int j = 0; j < 10; ++j) {
                String totp = TOTP.generateMyTOTP("account01", "12345");
                System.out.println(String.format("\u52a0\u5bc6\u540e: %s", totp));
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TOTP() {
    }

    public static String generateMyTOTP(String code, String pass) {
        long now = new Date().getTime();
        String time = Long.toHexString(TOTP.timeFactor(now)).toUpperCase();
        return TOTP.generateTOTP(code + pass + SECRET_KEY, time);
    }

    public static boolean verifyTOTPRigidity(String code, String pass, String totp) {
        return TOTP.generateMyTOTP(code, pass).equals(totp);
    }

    public static boolean verifyTOTPFlexibility(String code, String pass, String totp) {
        long now = new Date().getTime();
        String time = Long.toHexString(TOTP.timeFactor(now)).toUpperCase();
        String tempTotp = TOTP.generateTOTP(code + pass + SECRET_KEY, time);
        if (tempTotp.equals(totp)) {
            return true;
        }
        String time2 = Long.toHexString(TOTP.timeFactor(now - 5000L)).toUpperCase();
        String tempTotp2 = TOTP.generateTOTP(code + pass + SECRET_KEY, time2);
        return tempTotp2.equals(totp);
    }

    private static long timeFactor(long targetTime) {
        return (targetTime - 0L) / 3000L;
    }

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "AES");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, ret, 0, ret.length);
        return ret;
    }

    private static String generateTOTP(String key, String time) {
        return TOTP.generateTOTP(key, time, "HmacSHA1");
    }

    private static String generateTOTP256(String key, String time) {
        return TOTP.generateTOTP(key, time, "HmacSHA256");
    }

    private static String generateTOTP512(String key, String time) {
        return TOTP.generateTOTP(key, time, "HmacSHA512");
    }

    private static String generateTOTP(String key, String time, String crypto) {
        StringBuilder timeBuilder = new StringBuilder(time);
        while (timeBuilder.length() < 16) {
            timeBuilder.insert(0, "0");
        }
        time = timeBuilder.toString();
        byte[] msg = TOTP.hexStr2Bytes(time);
        byte[] k = key.getBytes();
        byte[] hash = TOTP.hmac_sha(crypto, k, msg);
        return TOTP.truncate(hash);
    }

    private static String truncate(byte[] target) {
        int offset = target[target.length - 1] & 0xF;
        int binary = (target[offset] & 0x7F) << 24 | (target[offset + 1] & 0xFF) << 16 | (target[offset + 2] & 0xFF) << 8 | target[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[6];
        StringBuilder result = new StringBuilder(Integer.toString(otp));
        while (result.length() < 6) {
            result.insert(0, "0");
        }
        return result.toString();
    }
}

