/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.logging.impl;

import com.ds.common.CommonConfig;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogConfigurationException;
import com.ds.common.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class LogFactoryImpl
extends LogFactory {
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{String.class};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{LogFactory.class};

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        Log instance = (Log)this.instances.get(name);
        if (instance == null) {
            instance = this.newInstance(name);
            this.instances.put(name, instance);
        }
        return instance;
    }

    @Override
    public void release() {
        this.instances.clear();
    }

    protected String getLogClassName() {
        if (this.logClassName != null) {
            return this.logClassName;
        }
        this.logClassName = CommonConfig.getValue(this.configKey + ".log.logger");
        if (this.logClassName == null && this.isLog4JAvailable()) {
            this.logClassName = "com.ds.common.logging.impl.Log4JLogger";
        }
        if (this.logClassName == null && this.isJdk14Available()) {
            this.logClassName = "com.ds.common.logging.impl.Jdk14Logger";
        }
        if (this.logClassName == null) {
            this.logClassName = "com.ds.common.logging.impl.SimpleLog";
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String logClassName = this.getLogClassName();
        Class logClass = null;
        try {
            logClass = LogFactoryImpl.loadClass(logClassName);
            if (logClass == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + logClassName);
            }
            if (!Log.class.isAssignableFrom(logClass)) {
                throw new LogConfigurationException("Class " + logClassName + " does not implement Log");
            }
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
        try {
            this.logMethod = logClass.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable t) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = logClass.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable t) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + logClassName, t);
        }
    }

    private static Class loadClass(final String name) throws ClassNotFoundException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = LogFactoryImpl.getContextClassLoader();
                if (threadCL != null) {
                    try {
                        return threadCL.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    return e;
                }
            }
        });
        if (result instanceof Class) {
            return (Class)result;
        }
        throw (ClassNotFoundException)result;
    }

    protected boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("com.ds.common.logging.impl.Jdk14Logger");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.slf4j.Logger");
            LogFactoryImpl.loadClass("com.ds.common.logging.impl.Log4JLogger");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected Log newInstance(String name) throws LogConfigurationException {
        Log instance = null;
        try {
            Object[] params = new Object[]{name};
            instance = (Log)this.getLogConstructor().newInstance(params);
            if (this.logMethod != null) {
                params[0] = this;
                this.logMethod.invoke((Object)instance, params);
            }
            return instance;
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }
}

