/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.logging.impl;

import com.ds.common.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log4JLogger
implements Log {
    private static final String FQCN = Log4JLogger.class.getName();
    private Logger logger = null;

    public Log4JLogger() {
    }

    public Log4JLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public Log4JLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(Object message) {
        this.logger.trace("{}", message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.logger.trace("{}", message, (Object)t);
    }

    @Override
    public void debug(Object message) {
        this.logger.debug("{}", message, null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.logger.debug("{}", message, (Object)t);
    }

    @Override
    public void info(Object message) {
        this.logger.info("{}", message, null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logger.info("{}", message, (Object)t);
    }

    @Override
    public void warn(Object message) {
        this.logger.warn("{}", message, null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.logger.warn("{},Stack:{}", message, (Object)t);
    }

    @Override
    public void error(Object message) {
        this.logger.error("CommonError:{}", message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logger.error("CommonError:{}", message, (Object)t);
    }

    @Override
    public void fatal(Object message) {
        this.logger.error("FatalError:{}", message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logger.error(FQCN, message, (Object)t);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }
}

