/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.logging;

import com.ds.common.CommonConfig;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogConfigurationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public abstract class LogFactory {
    public static final String FACTORY_DEFAULT = "com.ds.common.logging.impl.LogFactoryImpl";
    protected String configKey;
    protected static Map factories = new HashMap();

    protected LogFactory() {
    }

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public static LogFactory getFactory(String configKey) throws LogConfigurationException {
        ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LogFactory.getContextClassLoader();
            }
        });
        LogFactory factory = LogFactory.getCachedFactory(configKey);
        if (factory != null) {
            return factory;
        }
        String ref = CommonConfig.getValue(configKey + ".log.ref");
        if (ref != null && (factory = LogFactory.getCachedFactory(ref)) == null) {
            factory = LogFactory.getFactory(ref);
        }
        if (factory == null) {
            String factoryClass = CommonConfig.getValue(configKey + ".log.logFactory");
            if (factory == null && factoryClass != null) {
                factory = LogFactory.newFactory(factoryClass, contextClassLoader);
            }
        }
        if (factory == null) {
            factory = LogFactory.newFactory(FACTORY_DEFAULT, LogFactory.class.getClassLoader());
        }
        if (factory != null) {
            factory.configKey = configKey;
            LogFactory.cacheFactory(configKey, factory);
        }
        return factory;
    }

    public static Log getLog(String configKey, Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory(configKey).getInstance(clazz);
    }

    public static Log getLog(String configKey, String name) throws LogConfigurationException {
        return LogFactory.getFactory(configKey).getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(String configKey) {
        Map map = factories;
        synchronized (map) {
            LogFactory factory = (LogFactory)factories.get(configKey);
            if (factory != null) {
                factory.release();
                factories.remove(configKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Map map = factories;
        synchronized (map) {
            for (LogFactory element : factories.values()) {
                element.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = Thread.class.getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException e) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException e) {
            classLoader = LogFactory.class.getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(String configKey) {
        LogFactory factory = null;
        if (configKey != null) {
            factory = (LogFactory)factories.get(configKey);
        }
        return factory;
    }

    private static void cacheFactory(String configKey, LogFactory factory) {
        if (configKey != null && factory != null) {
            factories.put(configKey, factory);
        }
    }

    protected static LogFactory newFactory(final String factoryClass, final ClassLoader classLoader) throws LogConfigurationException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    block9: {
                        if (classLoader != null) {
                            try {
                                return (LogFactory)classLoader.loadClass(factoryClass).newInstance();
                            }
                            catch (ClassNotFoundException ex) {
                                if (classLoader == LogFactory.class.getClassLoader()) {
                                    throw ex;
                                }
                            }
                            catch (NoClassDefFoundError e) {
                                if (classLoader == LogFactory.class.getClassLoader()) {
                                    throw e;
                                }
                            }
                            catch (ClassCastException e) {
                                if (classLoader != LogFactory.class.getClassLoader()) break block9;
                                throw e;
                            }
                        }
                    }
                    return (LogFactory)Class.forName(factoryClass).newInstance();
                }
                catch (Exception e) {
                    return new LogConfigurationException(e);
                }
            }
        });
        if (result instanceof LogConfigurationException) {
            throw (LogConfigurationException)result;
        }
        return (LogFactory)result;
    }
}

