/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression.function.math;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Multiply
extends Function {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object product = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            product = this.mul(product, param);
        }
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.mul((Number)param1, (Number)param2);
            }
            if (param2 instanceof List) {
                return this.mul((List)param2, (Number)param1);
            }
        }
        if (param1 instanceof List) {
            if (param2 instanceof Number) {
                return this.mul((List)param1, (Number)param2);
            }
            if (param2 instanceof List) {
                return this.mul((List)param1, (List)param2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    protected Double mul(Number d1, Number d2) {
        return new Double(d1.doubleValue() * d2.doubleValue());
    }

    protected List mul(List v, Number d) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.add(this.mul((Number)v.get(i), d));
        }
        return result;
    }

    protected List mul(List v1, List v2) throws ParseException {
        List list1 = v1;
        List list2 = v2;
        int n = list1.size();
        ArrayList<Double> result = new ArrayList<Double>(n);
        if (n != list2.size()) {
            throw new ParseException("Unmatched List parameter size");
        }
        for (int i = 0; i < n; ++i) {
            result.add(this.mul((Number)list1.get(i), (Number)list2.get(i)));
        }
        return result;
    }
}

