/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression.function.logical;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Logical
extends Function {
    int id;

    public Logical(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        stack.push(this.logical(param1, param2));
    }

    protected Object logical(Object x, Object y) throws ParseException {
        if (x == null || y == null) {
            return null;
        }
        if (x instanceof Boolean && y instanceof Boolean) {
            return this.logical((boolean)((Boolean)x), (Boolean)y);
        }
        if (x instanceof Boolean && y instanceof List) {
            return this.logical((boolean)((Boolean)x), (List)y);
        }
        if (x instanceof List && y instanceof Boolean) {
            return this.logical((boolean)((Boolean)y), (List)x);
        }
        throw new ParseException("Invalid parameter type");
    }

    protected Boolean logical(boolean x, boolean y) throws ParseException {
        boolean b;
        switch (this.id) {
            case 0: {
                b = x && y;
                break;
            }
            case 1: {
                b = x || y;
                break;
            }
            default: {
                b = false;
            }
        }
        return new Boolean(b);
    }

    protected List logical(boolean x, List y) throws ParseException {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int n = y.size();
        for (int i = 0; i < n; ++i) {
            Object o = y.get(i);
            if (!(o instanceof Boolean)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.logical(x, (Boolean)o));
        }
        return result;
    }

    protected List logical(List x, List y) throws ParseException {
        if (x.size() != y.size()) {
            throw new ParseException("Unmatched List parameter size");
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int n = x.size();
        for (int i = 0; i < n; ++i) {
            Object o = x.get(i);
            Object oo = y.get(i);
            if (!(o instanceof Boolean) || !(oo instanceof Boolean)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.logical((boolean)((Boolean)o), (Boolean)oo));
        }
        return result;
    }
}

