/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression;

import com.ds.common.expression.EvaluatorVisitor;
import com.ds.common.expression.ExpressionParser;
import com.ds.common.expression.FunctionTable;
import com.ds.common.expression.Node;
import com.ds.common.expression.ParseException;
import com.ds.common.expression.Parser;
import com.ds.common.expression.ParserDumpVisitor;
import com.ds.common.expression.SymbolTable;
import com.ds.common.expression.function.Function;
import com.ds.common.expression.function.FunctionI;
import com.ds.common.expression.type.Complex;
import com.ds.common.expression.type.DoubleNumberFactory;
import com.ds.common.expression.type.NumberFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.Constants;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class JEP
implements ExpressionParser {
    private String expression;
    protected static Log log = LogFactory.getLog(Constants.COMMON_CONFIGKEY, JEP.class);
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    private Parser parser;
    private Node topNode = null;
    private EvaluatorVisitor ev;
    private NumberFactory numberFactory;
    static int k = 0;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = true;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.addStandardFunctions();
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
        this.addStandardFunctions();
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    @Override
    public void addStandardFunctions() {
    }

    @Override
    public void addStandardConstants() {
        this.symTab.put("pi", new Double(Math.PI));
        this.symTab.put("e", new Double(Math.E));
    }

    public void addFunction(String functionName, FunctionI function) {
        this.funTab.put(functionName, function);
    }

    @Override
    public void addFunction(String functionName, Function function) {
        if (this.funTab.containsKey(functionName) && !this.funTab.get(functionName).getClass().getName().equals(function.getClass().getName())) {
            log.error("load Function err expression=<<" + functionName + ">> def in 2 class [" + this.funTab.get(functionName).getClass().getName() + "," + function.getClass().getName() + "]");
        }
        this.funTab.put(functionName, function);
    }

    @Override
    public void addFuntionTable(FunctionTable functionTable) {
        if (functionTable == null) {
            return;
        }
        for (Map.Entry entry : functionTable.entrySet()) {
            this.funTab.put(entry.getKey(), entry.getValue());
        }
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.put(name, object);
        return object;
    }

    @Override
    public void addVariableAsObject(String name, Object object) {
        this.symTab.put(name, object);
    }

    @Override
    public Object removeVariable(String name) {
        return this.symTab.remove(name);
    }

    @Override
    public Object removeFunction(String name) {
        return this.funTab.remove(name);
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    @Override
    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    @Override
    public boolean parseExpression(String expression_in) {
        log.info("expression: " + expression_in);
        this.expression = expression_in;
        if (expression_in.equals("")) {
            return true;
        }
        StringReader reader = new StringReader(new String(expression_in));
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            log.error("parse expression error: " + this.expression, e);
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getErrorInfo());
            } else {
                this.errorList.addElement("Syntax error");
            }
            return false;
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
        }
        return this.errorList.isEmpty();
    }

    public double getValue() throws Exception {
        Object value = this.getValueAsObject();
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Complex) {
            return ((Complex)value).re();
        }
        return 0.0;
    }

    @Override
    public Object getValueAsObject() {
        if (this.expression.equals("")) {
            return null;
        }
        Object result = null;
        if (this.topNode != null && !this.hasError()) {
            try {
                result = this.ev.getValue(this.topNode, this.errorList, this.symTab);
            }
            catch (Exception e) {
                log.error("getValueAsObject error: " + this.expression, e);
                this.errorList.add(e.getClass().getName());
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    @Override
    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                str = str + this.errorList.elementAt(i) + "\n";
            }
            return str;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    @Override
    public HashMap getSymbolTable() {
        return this.symTab;
    }

    @Override
    public Hashtable getFunctionTable() {
        return this.funTab;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    @Override
    public void addVariableNames(String[] names) {
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            this.addVariableAsObject(names[i], null);
        }
    }
}

