/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression;

import com.ds.common.expression.ASTConstant;
import com.ds.common.expression.ASTFunNode;
import com.ds.common.expression.ASTStart;
import com.ds.common.expression.ASTVarNode;
import com.ds.common.expression.Node;
import com.ds.common.expression.ParseException;
import com.ds.common.expression.ParserVisitor;
import com.ds.common.expression.SimpleNode;
import com.ds.common.expression.SymbolTable;
import com.ds.common.expression.function.FunctionI;
import java.util.Stack;
import java.util.Vector;

public class EvaluatorVisitor
implements ParserVisitor {
    private Stack stack = new Stack();
    private Vector errorList = null;
    private SymbolTable symTab = null;
    private boolean errorFlag;
    private static final boolean debug = false;

    private void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws Exception {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        topNode.jjtAccept(this, null);
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        data = node.childrenAccept(this, data);
        FunctionI pfmc = node.getPFMC();
        if (pfmc == null) {
            this.addToErrorList("No function class associated with " + node.getName());
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            pfmc.run(this.stack);
        }
        catch (ParseException e) {
            this.addToErrorList(e.getMessage());
            this.errorFlag = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) {
        String message = "Could not evaluate " + node.getName() + ": ";
        if (this.symTab == null) {
            message = message + "the symbol table is null";
            this.addToErrorList(message);
            return data;
        }
        Object temp = this.symTab.get(node.getName());
        this.stack.push(temp);
        return data;
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }
}

