/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache.redis;

import com.ds.common.CommonConfig;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class RedisPoolUtil {
    private static final Log logger = LogFactory.getLog("JDS", RedisPoolUtil.class);
    private static String SERVER_URL = "192.168.80.64";
    private static int PORT = 6379;
    private static String PASSWORD = null;
    private static int MAXTOTAL = 100;
    private static int MAXIDLE = 50;
    private static int MAXWAITMILLS = 50000;
    private static boolean TESTONRETURN = true;
    private static boolean TESTWHILEIDLE = true;
    private static int TIMEOUT = 1000;
    private JedisPoolAbstract POOL = null;
    private String REDISKEY = "REDIS";
    public static final String THREAD_LOCK = "Thread Lock";
    private static Map<String, RedisPoolUtil> poolUtilMap = new HashMap<String, RedisPoolUtil>();

    private RedisPoolUtil(String key) {
        this.REDISKEY = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisPoolUtil getInstance(String redisKey) {
        String string = redisKey.intern();
        synchronized (string) {
            RedisPoolUtil REDIS_POOL_UTIL = poolUtilMap.get(redisKey);
            if (null == REDIS_POOL_UTIL && null == REDIS_POOL_UTIL) {
                REDIS_POOL_UTIL = new RedisPoolUtil(redisKey);
                poolUtilMap.put(redisKey, REDIS_POOL_UTIL);
            }
            return REDIS_POOL_UTIL;
        }
    }

    public void init() {
        JedisPoolConfig config = new JedisPoolConfig();
        this.loadProperties();
        config.setMaxTotal(MAXTOTAL);
        config.setMaxIdle(MAXIDLE);
        config.setMaxWaitMillis((long)MAXWAITMILLS);
        config.setTestOnReturn(TESTONRETURN);
        config.setTestWhileIdle(TESTWHILEIDLE);
        logger.info("start init redis pool :[" + this.REDISKEY + "]");
        logger.info("************************************************");
        logger.info("- redis " + this.REDISKEY + "[SERVER_URL] :   " + SERVER_URL + "*");
        logger.info("- redis " + this.REDISKEY + "[PORT] :   " + PORT + "*");
        logger.info("- redis " + this.REDISKEY + "[MAXTOTAL] :   " + MAXTOTAL + "*");
        logger.info("- redis " + this.REDISKEY + "[MAXIDLE] :   " + MAXIDLE + "*");
        logger.info("************************************************");
        if (SERVER_URL.indexOf(";") > -1) {
            HashSet<String> urlSet = new HashSet<String>();
            for (String url : SERVER_URL.split(";")) {
                urlSet.add(url);
            }
            String masterName = System.getProperty("masterName");
            this.POOL = new JedisSentinelPool(masterName, urlSet, (GenericObjectPoolConfig)config, PASSWORD);
        } else {
            this.POOL = new JedisPool((GenericObjectPoolConfig)config, SERVER_URL, PORT, TIMEOUT, PASSWORD);
        }
    }

    public synchronized Jedis getClient() {
        if (this.POOL == null) {
            try {
                this.init();
                return (Jedis)this.POOL.getResource();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u65b0\u5efaredis\u8fde\u63a5");
                return new Jedis(SERVER_URL, 6379);
            }
        }
        return (Jedis)this.POOL.getResource();
    }

    public synchronized void closeConn(Jedis jedis) {
        try {
            if (jedis != null) {
                jedis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u5f52\u8fd8\u8fde\u63a5\u5931\u8d25");
        }
    }

    public byte[] serialize(Object obj) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        if (obj == null) {
            return null;
        }
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            byte[] byt = bos.toByteArray();
            return byt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object unserizlize(byte[] byt) {
        if (byt == null) {
            return null;
        }
        ObjectInputStream oii = null;
        ByteArrayInputStream bis = null;
        bis = new ByteArrayInputStream(byt);
        try {
            oii = new ObjectInputStream(bis);
            Object obj = oii.readObject();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void loadProperties() {
        String serverUrl = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.serverURL");
        String port = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.port");
        String password = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.password");
        String maxTotal = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.maxTotal");
        String maxIdle = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.maxIdle");
        String maxWaitMillis = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.maxWaitMillis");
        String testOnReturn = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.testOnReturn");
        String testWhileIdle = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.testWhileIdle");
        String timeOut = CommonConfig.getValue(this.REDISKEY + ".database.defaultProvider.timeout");
        try {
            if (serverUrl != null) {
                SERVER_URL = serverUrl;
            }
            if (port != null) {
                PORT = Integer.parseInt(port);
            }
            if (password != null) {
                PASSWORD = String.valueOf(password);
            }
            if (maxTotal != null) {
                MAXTOTAL = Integer.parseInt(maxTotal);
            }
            if (maxIdle != null) {
                MAXIDLE = Integer.parseInt(maxIdle);
            }
            if (maxWaitMillis != null) {
                MAXWAITMILLS = Integer.parseInt(maxWaitMillis);
            }
            if (testOnReturn != null) {
                TESTONRETURN = Boolean.valueOf(testOnReturn);
            }
            if (testWhileIdle != null) {
                TESTWHILEIDLE = Boolean.valueOf(testWhileIdle);
            }
            if (timeOut != null) {
                TIMEOUT = Integer.parseInt(timeOut);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

