/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache.redis;

import com.ds.common.CommonConfig;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManager;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.cache.redis.RedisCache;
import java.util.HashMap;
import java.util.Map;

public class RedisCacheManager
implements CacheManager {
    private final boolean cacheEnabled = true;
    private String configKey = null;
    private String driver;
    private String serverURL = "192.168.80.64";
    private final int port = 6379;
    private String username;
    private String password;
    private static final String MEMKEY = "REDIS";
    private int minConnections = 3;
    private int maxConnections = 10;
    private int connectionTimeout = 30000;
    private static final Map CACHES = new HashMap();
    public static final String THREAD_LOCK = "Thread Lock";

    private RedisCacheManager() {
    }

    public RedisCacheManager(String systemCode) {
        String databsekey = MEMKEY;
        String key = systemCode + ".cache." + CacheManagerFactory.REFKEY;
        databsekey = CommonConfig.getValue(key);
        if (databsekey != null) {
            this.configKey = databsekey;
        }
        System.out.println("configkey : " + this.configKey);
        this.loadProperties();
    }

    private void loadProperties() {
        this.driver = CommonConfig.getValue(this.configKey + ".database.defaultProvider.driver");
        this.serverURL = CommonConfig.getValue(this.configKey + ".database.defaultProvider.serverURL");
        this.username = CommonConfig.getValue(this.configKey + ".database.defaultProvider.username");
        this.password = CommonConfig.getValue(this.configKey + ".database.defaultProvider.password");
        String minCons = CommonConfig.getValue(this.configKey + ".database.defaultProvider.minConnections");
        String maxCons = CommonConfig.getValue(this.configKey + ".database.defaultProvider.maxConnections");
        String conTimeout = CommonConfig.getValue(this.configKey + ".database.defaultProvider.connectionTimeout");
        try {
            if (minCons != null) {
                this.minConnections = Integer.parseInt(minCons);
            }
            if (maxCons != null) {
                this.maxConnections = Integer.parseInt(maxCons);
            }
            if (conTimeout != null) {
                this.connectionTimeout = Integer.parseInt(conTimeout);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cache createCache(String name, int maxcacheSIze, long maxLifetime) {
        return this.getCacheNS(name, maxcacheSIze, maxLifetime);
    }

    public Cache getCacheNS(String cacheKey) {
        int cacheSIze = 0xA00000;
        String cacheSIzeString = CommonConfig.getValue(this.configKey + ".cache." + cacheKey + ".size");
        if (cacheSIzeString != null) {
            try {
                cacheSIze = Integer.parseInt(cacheSIzeString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long cacheLifeTime = 604800000L;
        String cacheLifeTimeString = CommonConfig.getValue(this.configKey + ".cache." + cacheKey + ".lifeTime");
        if (cacheLifeTimeString != null) {
            try {
                cacheLifeTime = Long.parseLong(cacheLifeTimeString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getCacheNS(cacheKey, cacheSIze, cacheLifeTime);
    }

    private Cache getCacheNS(String cacheKey, int maxcacheSIze, long maxLifetime) {
        String key = this.configKey + "." + cacheKey;
        RedisCache cache = (RedisCache)CACHES.get(key);
        if (cache == null) {
            cache = new RedisCache(this.configKey, cacheKey, maxcacheSIze, maxLifetime);
            CACHES.put(key, cache);
        }
        return cache;
    }

    public Map getAllCacheNS() {
        return CACHES;
    }

    public Map getAllCache() {
        return this.getAllCacheNS();
    }

    public boolean isCacheEnabledNS() {
        return true;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.isCacheEnabledNS();
    }

    public Cache getCache(String cacheKey) {
        return this.getCacheNS(cacheKey);
    }
}

