/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache;

import com.ds.common.CommonConfig;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheFactory;
import com.ds.common.cache.CacheManager;
import com.ds.common.cache.DefaultCache;
import java.util.Map;
import java.util.TreeMap;

public class MemCacheManager
implements CacheManager {
    private Map cacheMap = new TreeMap();
    private String configKey;
    private boolean cacheEnabled = true;

    public MemCacheManager(String configKey) {
        this.configKey = configKey;
        this.init();
    }

    private void init() {
        String enabled = CommonConfig.getValue(this.configKey + ".cache.enabled");
        if (enabled != null) {
            try {
                this.cacheEnabled = Boolean.valueOf(enabled);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Cache createCache(String name, int maxCacheSize, long maxLifetime) {
        DefaultCache cache = (DefaultCache)this.cacheMap.get(name);
        if (cache != null) {
            return cache;
        }
        cache = new DefaultCache(name, maxCacheSize, maxLifetime);
        this.cacheMap.put(name, cache);
        return cache;
    }

    public Cache getCache(String cacheKey) {
        Cache cache = (Cache)this.cacheMap.get(cacheKey);
        if (cache == null) {
            int cacheSize = 0x1E00000;
            String cacheSizeString = CommonConfig.getValue(this.configKey + ".cache." + cacheKey + ".size");
            if (cacheSizeString != null) {
                try {
                    cacheSize = Integer.parseInt(cacheSizeString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long cacheLifeTime = 2592000000L;
            String cacheLifeTimeString = CommonConfig.getValue(this.configKey + ".cache." + cacheKey + ".lifeTime");
            if (cacheLifeTimeString != null) {
                try {
                    cacheLifeTime = Long.parseLong(cacheLifeTimeString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cache = CacheFactory.createCache(this.configKey + "." + cacheKey, cacheSize, cacheLifeTime);
            this.cacheMap.put(this.configKey + "." + cacheKey, cache);
        }
        return cache;
    }

    public Map getAllCache() {
        return this.cacheMap;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }
}

