/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheObject;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.cache.LinkedList;
import com.ds.common.cache.LinkedListNode;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.Constants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultCache<K, V>
implements Cache<K, V> {
    private static final Log log = LogFactory.getLog(Constants.COMMON_CONFIGKEY, DefaultCache.class);
    protected Map map;
    protected LinkedList lastAccessedList;
    protected LinkedList ageList;
    protected int maxCacheSize;
    protected int cacheSize = 0;
    protected long maxLifetime;
    protected long cacheHits;
    protected long cacheMisses = 0L;
    protected String name;
    private boolean isFull;
    protected boolean isStopPutWhenFull;

    protected DefaultCache(String name, int maxSize, long maxLifetime) {
        this.name = name;
        this.maxCacheSize = maxSize;
        this.maxLifetime = maxLifetime;
        this.map = new HashMap(103);
        this.lastAccessedList = new LinkedList();
        this.ageList = new LinkedList();
    }

    @Override
    public synchronized V put(K key, V value) {
        LinkedListNode lastAccessedNode;
        if (key == null) {
            return null;
        }
        key = key.toString();
        if (this.isStopPutWhenFull && this.isFull) {
            return value;
        }
        int objectSize = this.calculateSize(value);
        if (this.maxCacheSize > 0 && (double)objectSize > (double)this.maxCacheSize * 0.9) {
            return value;
        }
        this.cacheSize += objectSize;
        if (this.isStopPutWhenFull && this.maxCacheSize > 0 && this.cacheSize > this.maxCacheSize) {
            this.isFull = true;
            return value;
        }
        this.remove(key);
        CacheObject cacheObject = new CacheObject(value, objectSize);
        this.map.put(key, cacheObject);
        cacheObject.lastAccessedListNode = lastAccessedNode = this.lastAccessedList.addFirst(key);
        LinkedListNode ageNode = this.ageList.addFirst(key);
        ageNode.timestamp = System.currentTimeMillis();
        cacheObject.ageListNode = ageNode;
        if (!this.isStopPutWhenFull) {
            this.cullCache();
        }
        return value;
    }

    @Override
    public synchronized V get(Object key) {
        this.deleteExpiredEntries();
        if (key == null) {
            return null;
        }
        CacheObject cacheObject = (CacheObject)this.map.get(key = key.toString());
        if (cacheObject == null) {
            ++this.cacheMisses;
            return null;
        }
        ++this.cacheHits;
        ++cacheObject.readCount;
        cacheObject.lastAccessedListNode.remove();
        this.lastAccessedList.addFirst(cacheObject.lastAccessedListNode);
        return (V)cacheObject.object;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        CacheObject cacheObject = (CacheObject)this.map.get(key = key.toString());
        if (cacheObject == null) {
            return null;
        }
        this.map.remove(key);
        this.isFull = false;
        cacheObject.lastAccessedListNode.remove();
        cacheObject.ageListNode.remove();
        cacheObject.ageListNode = null;
        cacheObject.lastAccessedListNode = null;
        this.cacheSize -= cacheObject.size;
        return (V)cacheObject.object;
    }

    @Override
    public synchronized void clear() {
        Object[] keys = this.map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
        this.map.clear();
        this.lastAccessedList.clear();
        this.lastAccessedList = new LinkedList();
        this.ageList.clear();
        this.ageList = new LinkedList();
        this.cacheSize = 0;
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.isFull = false;
    }

    @Override
    public int size() {
        this.deleteExpiredEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.deleteExpiredEntries();
        return this.map.isEmpty();
    }

    @Override
    public Collection values() {
        this.deleteExpiredEntries();
        Object[] cacheObjects = this.map.values().toArray();
        Object[] values = new Object[cacheObjects.length];
        for (int i = 0; i < cacheObjects.length; ++i) {
            values[i] = ((CacheObject)cacheObjects[i]).object;
        }
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        key = key.toString();
        this.deleteExpiredEntries();
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Object key : this.map.keySet()) {
            if (key == null) continue;
            Object value = this.map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.deleteExpiredEntries();
        int objectSize = this.calculateSize(value);
        CacheObject cacheObject = new CacheObject(value, objectSize);
        return this.map.containsValue(cacheObject);
    }

    @Override
    public Set entrySet() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Override
    public Set keySet() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public K getName() {
        return (K)this.name;
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public long getCacheMisses() {
        return this.cacheMisses;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cullCache();
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    protected int calculateSize(Object object) {
        if (object instanceof Cacheable) {
            return ((Cacheable)object).getCachedSize();
        }
        if (object instanceof DataInputStream) {
            int size = 1;
            try {
                size = ((DataInputStream)object).available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return size;
        }
        if (object instanceof Long) {
            return CacheSizes.sizeOfLong();
        }
        if (object instanceof Integer) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfInt();
        }
        if (object instanceof Boolean) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfBoolean();
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            return CacheSizes.sizeOfObject() + array.length * CacheSizes.sizeOfLong();
        }
        int size = 1;
        try {
            NullOutputStream out = new NullOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(out);
            outObj.writeObject(object);
            size = out.size();
        }
        catch (IOException ioe) {
            size = 1024;
        }
        return size;
    }

    protected void deleteExpiredEntries() {
        if (this.maxLifetime <= 0L) {
            return;
        }
        LinkedListNode node = this.ageList.getLast();
        if (node == null) {
            return;
        }
        long expireTime = System.currentTimeMillis() - this.maxLifetime;
        while (expireTime > node.timestamp) {
            this.remove(node.object);
            node = this.ageList.getLast();
            if (node != null) continue;
            return;
        }
    }

    protected void cullCache() {
        if (this.maxCacheSize < 0) {
            return;
        }
        if ((double)this.cacheSize >= (double)this.maxCacheSize * 0.97) {
            this.deleteExpiredEntries();
            int desiredSize = (int)((double)this.maxCacheSize * 0.9);
            while (this.cacheSize > desiredSize) {
                this.remove(this.lastAccessedList.getLast().object);
            }
        }
    }

    @Override
    public void setStopPutWhenFull(boolean flag) {
        this.isStopPutWhenFull = flag;
    }

    private static class NullOutputStream
    extends OutputStream {
        int size = 0;

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += len;
        }

        public int size() {
            return this.size;
        }
    }
}

