/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache;

import com.ds.common.cache.Cacheable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class CacheSizes {
    public static int sizeOfObject() {
        return 4;
    }

    public static int sizeOfObject(Object obj) {
        if (obj == null) {
            return 4;
        }
        int size = 0;
        if (obj instanceof String) {
            size += CacheSizes.sizeOfString((String)obj);
        } else if (obj instanceof Long) {
            size += CacheSizes.sizeOfLong() + CacheSizes.sizeOfObject();
        } else if (obj instanceof Integer) {
            size += CacheSizes.sizeOfInt() + CacheSizes.sizeOfObject();
        } else if (obj instanceof Double) {
            size += CacheSizes.sizeOfDouble() + CacheSizes.sizeOfObject();
        } else if (obj instanceof Boolean) {
            size += CacheSizes.sizeOfBoolean() + CacheSizes.sizeOfObject();
        } else if (obj instanceof Character) {
            size += CacheSizes.sizeOfChar() + CacheSizes.sizeOfObject();
        } else if (obj instanceof Map) {
            size += CacheSizes.sizeOfMap((Map)obj);
        } else if (obj instanceof List) {
            size += CacheSizes.sizeOfList((List)obj);
        } else if (obj instanceof Cacheable) {
            size += ((Cacheable)obj).getCachedSize();
        } else {
            try {
                NullOutputStream out = new NullOutputStream();
                ObjectOutputStream outObj = new ObjectOutputStream(out);
                outObj.writeObject(obj);
                size += out.size();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                size += 4;
            }
        }
        return size;
    }

    public static int sizeOfString(String string) {
        if (string == null) {
            return 4;
        }
        return 4 + string.length() * 2;
    }

    public static int sizeOfInt() {
        return 4;
    }

    public static int sizeOfChar() {
        return 2;
    }

    public static int sizeOfBoolean() {
        return 1;
    }

    public static int sizeOfLong() {
        return 8;
    }

    public static int sizeOfDouble() {
        return 8;
    }

    public static int sizeOfDate() {
        return 12;
    }

    public static int sizeOfMap(Map map) {
        if (map == null) {
            return 4;
        }
        int size = 36;
        Object[] values = map.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            size += CacheSizes.sizeOfObject(values[i]);
        }
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            size += CacheSizes.sizeOfObject(keys[i]);
        }
        return size;
    }

    public static int sizeOfList(List list) {
        if (list == null) {
            return 4;
        }
        int size = 36;
        Object[] values = list.toArray();
        for (int i = 0; i < values.length; ++i) {
            Object obj = values[i];
            size += CacheSizes.sizeOfObject(obj);
        }
        return size;
    }

    private static class NullOutputStream
    extends OutputStream {
        int size = 0;

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += len;
        }

        public int size() {
            return this.size;
        }
    }
}

