/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache;

import com.ds.common.CommonConfig;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManager;
import com.ds.common.cache.MemCacheManager;
import com.ds.common.cache.redis.RedisCacheManager;
import java.util.Map;
import java.util.TreeMap;

public class CacheManagerFactory {
    private static CacheManagerFactory instance = null;
    private static Map cacheManagers;
    public static String REFKEY;
    public static final String THREAD_LOCK = "Thread Lock";
    public static String HTTPCACHE;
    public static final long DEFAULT_CACHEEXPIRETIME = 864000000000L;
    public static final Integer DEFAULT_CACHESIZE;

    private CacheManagerFactory() {
        cacheManagers = new TreeMap();
    }

    public Map getCacheManagerMap() {
        return cacheManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManagerFactory getInstance() {
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance == null) {
                instance = new CacheManagerFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public CacheManager getCacheManager(String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException("Parameters 'configKey' can't be null.");
        }
        CacheManager manager = (CacheManager)cacheManagers.get(configKey);
        if (manager == null) {
            manager = this.loadCacheManager(configKey);
            cacheManagers.put(configKey, manager);
        }
        return manager;
    }

    protected static <T> Cache<String, T> getCache(String configKey, String cacheKey) {
        return CacheManagerFactory.getInstance().getCacheManager(configKey).getCache(cacheKey);
    }

    public static <T> Cache<String, T> createCache(String configKey, String cacheName) {
        return CacheManagerFactory.createCache(configKey, cacheName, DEFAULT_CACHESIZE, 864000000000L);
    }

    public static <T> Cache<String, T> createCache(String configKey, String cacheName, int maxCacheSize, long maxLifetime) {
        return CacheManagerFactory.getInstance().getCacheManager(configKey).createCache(configKey + "." + cacheName, maxCacheSize, maxLifetime);
    }

    private CacheManager loadCacheManager(String configKey) {
        CacheManager manager = null;
        String databsekey = CommonConfig.getValue(configKey + ".cache." + REFKEY);
        manager = databsekey != null ? (databsekey.startsWith("REDIS") ? new RedisCacheManager(configKey) : new MemCacheManager(configKey)) : new MemCacheManager(configKey);
        return manager;
    }

    static {
        REFKEY = "databaseRef";
        HTTPCACHE = "HTTPCACHE";
        DEFAULT_CACHESIZE = 0xA00000;
    }
}

