/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common;

import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import java.io.File;

public class CommonConfig {
    public static final String CONFIG_FILENAME = "common_config.xml";
    private static XMLProperties properties = null;

    public static String getValue(String name) {
        CommonConfig.init();
        if (properties != null) {
            return properties.getProperty(name);
        }
        return null;
    }

    public static void reLoad() {
        properties.reLoad();
        CommonConfig.init();
    }

    public static String[] getValues(String name) {
        CommonConfig.init();
        if (properties != null) {
            return properties.getProperties(name);
        }
        return new String[0];
    }

    private static void init() {
        if (properties == null) {
            File engineConfigFile = new File(JDSConfig.Config.configPath(), CONFIG_FILENAME);
            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(JDSConfig.Config.publicConfigPath(), CONFIG_FILENAME);
            }
            if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath("/");
                engineConfigFile = new File(path, CONFIG_FILENAME);
            }
            properties = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
        }
    }
}

