/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.udp.UDPClient;
import com.ds.jds.core.User;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UDPControl
implements Runnable {
    public static final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private String msgId;
    private User user;
    private String status;

    public UDPControl(User user, String msgId, String status) {
        this.msgId = msgId;
        this.user = user;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.msgId != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sessionId", this.user.getSessionId());
            map.put("systemCode", this.user.getSystemCode());
            map.put("msgId", this.msgId);
            map.put("status", this.status);
            String mpStr = JSONObject.toJSONString(map);
            URL url = null;
            try {
                lock.writeLock().lock();
                url = new URL("http://" + this.user.getUdpIP());
                DatagramPacket hp = new DatagramPacket(URLEncoder.encode(mpStr).getBytes(), URLEncoder.encode(mpStr).length(), InetAddress.getByName(url.getHost()), this.user.getUdpPort());
                UDPClient.getInstance().getClientSocket().send(hp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }
}

