/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.ds.cluster.event.ClusterEventControl;
import com.ds.cluster.event.ServerEvent;
import com.ds.cluster.service.ServerEventFactory;
import com.ds.cluster.udp.ClusterClient;
import com.ds.cluster.udp.ClusterCommand;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.cluster.udp.ClusterExeCMDControl;
import com.ds.cluster.udp.ClusterExeEventControl;
import com.ds.cluster.udp.HeartThread;
import com.ds.cluster.udp.UDPControl;
import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.config.UserBean;
import com.ds.engine.event.JDSEvent;
import com.ds.enums.MsgStatus;
import com.ds.enums.ServerEventEnums;
import com.ds.jds.core.User;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.thread.JDSThreadFactory;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;

public class UDPClient {
    private static UDPClient instance;
    private DatagramSocket clientSocket;
    public static final String THREAD_LOCK = "Thread Lock";
    private String code;
    public static final String SUCCESS_KEY = "success";
    public static final String ERROR_KEY = "error";
    public static final String HIT_KEY = "0";
    public static final String START_KEY = "{";
    public static final String END_KEY = "}";
    public static final String STATUS_SPLIT_KEY = "&&";
    public static final String STATUS_START_KEY = "##||";
    public static final String STATUS_END_KEY = "||##";
    public static final String SESSIONID = "sessionId";
    public static final String EVENTKEY = "event";
    public static final String SYSTEMCODE = "systemCode";
    private static final String USERNAME = "userName";
    private static final String PASSWORD = "password";
    Async async = Async.newInstance();
    private static final Log logger;
    static Map<User, ClusterClient> clientMap;
    public static Cache<String, Long> msgCache;
    static ExecutorService cmdService;
    static ExecutorService udpService;
    private static final SerializeConfig config;
    private static HeartThread hearttask;
    private User user;
    public boolean isLogin = false;
    public boolean isClient = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static UDPClient getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new UDPClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void stop() {
        cmdService.shutdownNow();
        clientMap.clear();
        this.isLogin = false;
        if (this.clientSocket != null && !this.clientSocket.isClosed()) {
            this.clientSocket.close();
        }
        this.clientSocket = null;
    }

    public synchronized User login() {
        if (!this.isClient) {
            try {
                logger.info("*********************************Start UPD Connect******************************************");
                this.user = this.ajaxlogin();
                try {
                    ServerEventFactory.getInstance().initEvent(this.user);
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                String loginStr = JSONObject.toJSONString((Object)this.user);
                this.isLogin = true;
                this.startHeart(this.user);
            }
            catch (Exception e) {
                logger.error("loginException:", e);
            }
        } else {
            try {
                this.clientLogin(UserBean.getInstance());
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return this.user;
    }

    public synchronized User clientLogin(UserBean userBean) throws JDSException {
        this.isClient = true;
        logger.info("*********************************Start UPD Connect******************************************");
        this.user = this.clientAjaxLogin(userBean);
        try {
            ServerEventFactory.getInstance().initEvent(this.user);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        String loginStr = JSONObject.toJSONString((Object)this.user);
        this.isLogin = true;
        this.startHeart(this.user);
        return this.user;
    }

    private User clientAjaxLogin(UserBean userBean) throws JDSException {
        String newPWD = userBean.getUserpassword();
        newPWD = MD5.getHashString(newPWD);
        String userName = userBean.getUsername();
        String systemCode = userBean.getSystemCode();
        Request request = Request.Post((String)(userBean.getServerUrl() + userBean.getClitentLoginUrl())).bodyForm((Iterable)Form.form().add(USERNAME, userName).add("JSESSIONID", "").add(PASSWORD, newPWD).build(), Charset.forName("utf-8"));
        String json = null;
        try {
            json = request.execute().returnContent().asString();
        }
        catch (Exception e2) {
            throw new JDSException("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01");
        }
        logger.info("ajaxlogin-return-json:" + json);
        JSONObject jsonobj = JSONObject.parseObject((String)json);
        if (!jsonobj.containsKey((Object)"requestStatus") || jsonobj.getInteger("requestStatus") == -1) {
            logger.error("ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode);
            String msg = "\u767b\u5f55\u5931\u8d25\uff01";
            if (jsonobj.get((Object)"errdes") != null) {
                msg = jsonobj.get((Object)"errdes").toString();
            }
            throw new JDSException(msg);
        }
        this.user = (User)jsonobj.getObject("data", User.class);
        this.user.setPassword(newPWD);
        UserBean.getInstance().setConfigName(this.user.getConfigName());
        UserBean.getInstance().setSystemCode(this.user.getSystemCode());
        UserBean.getInstance().setPersonid(this.user.getId());
        logger.info("\u767b\u9646\u7528\u6237\u4fe1\u606f:user=" + JSON.toJSONString((Object)this.user));
        JDSServer.getInstance();
        return this.user;
    }

    public User ajaxlogin() throws ClientProtocolException, IOException, JDSException {
        String newPWD = UserBean.getInstance().getUserpassword();
        newPWD = MD5.getHashString(newPWD);
        final String userName = UserBean.getInstance().getUsername();
        final String systemCode = UserBean.getInstance().getSystemCode();
        Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + UserBean.getInstance().getLoginUrl())).bodyForm((Iterable)Form.form().add(USERNAME, userName).add(SYSTEMCODE, systemCode).add("JSESSIONID", "").add(PASSWORD, newPWD).build(), Charset.forName("utf-8"));
        Future future = this.async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
                logger.info("content" + content);
            }

            public void cancelled() {
                logger.warn("ajaxlogin-cancelleduserName=" + userName + "systemCode=" + systemCode);
            }
        });
        String json = null;
        try {
            json = ((Content)future.get()).asString();
        }
        catch (InterruptedException e1) {
            logger.error("InterruptedException-ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode, e1);
        }
        catch (ExecutionException e2) {
            logger.error("ExecutionException-ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode, e2);
        }
        logger.info("ajaxlogin-return-json:" + json);
        JSONObject jsonobj = JSONObject.parseObject((String)json);
        while (json == null || !jsonobj.containsKey((Object)"data")) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error("sleepException", e);
            }
            try {
                future = this.async.execute(request);
                json = ((Content)future.get()).asString();
                jsonobj = JSONObject.parseObject((String)json);
            }
            catch (InterruptedException e1) {
                logger.error("InterruptedException-ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode, e1);
            }
            catch (ExecutionException e2) {
                logger.error("ExecutionException-ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode, e2);
            }
        }
        if (!jsonobj.containsKey((Object)"requestStatus") || jsonobj.getInteger("requestStatus") == -1) {
            logger.error("ajaxlogin(\u767b\u9646\u5931\u8d25):userName=" + userName + "systemCode=" + systemCode);
            throw new JDSException("\u767b\u5f55\u5931\u8d25\uff01");
        }
        this.user = (User)jsonobj.getObject("data", User.class);
        this.user.setPassword(newPWD);
        UserBean.getInstance().setPersonid(this.user.getId());
        logger.info("\u767b\u9646\u7528\u6237\u4fe1\u606f:user=" + JSON.toJSONString((Object)this.user));
        JDSServer.getInstance();
        return this.user;
    }

    public void startHeart(User user) {
        if (hearttask != null && hearttask.getDs() != null && !hearttask.getDs().isClosed() && !cmdService.isShutdown()) {
            hearttask.setUser(user);
            hearttask.setDs(this.clientSocket);
        } else {
            hearttask = new HeartThread(this.clientSocket, user);
            if (cmdService.isShutdown()) {
                cmdService = Executors.newSingleThreadScheduledExecutor(new JDSThreadFactory("UDPClient[" + user.getId() + "]"));
            }
            cmdService.submit(hearttask);
        }
    }

    public boolean send(String msgString) {
        try {
            JSONObject jsonObject;
            msgString = msgString.trim();
            if (msgString.startsWith(START_KEY) && msgString.endsWith(END_KEY) && (jsonObject = JSONObject.parseObject((String)msgString)).containsKey((Object)"msgId")) {
                String msgId = jsonObject.getString("msgId");
                msgCache.put(msgId, System.currentTimeMillis());
                try {
                    RuntimeLog log = ConnectionLogFactory.getInstance().createLog(msgId, "UDP://" + this.user.getUdpIP() + ":[" + this.user.getSystemCode() + "]", "local send ", msgId);
                    log.setStartTime(System.currentTimeMillis());
                    log.setRequestJson(msgString);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (this.user != null && this.user.getUdpIP() != null && this.clientSocket != null) {
                URL url = new URL("http://" + this.user.getUdpIP());
                msgString = URLEncoder.encode(msgString, "utf-8");
                DatagramPacket hp = new DatagramPacket(msgString.getBytes(), msgString.length(), InetAddress.getByName(url.getHost()), this.user.getUdpPort());
                this.clientSocket.send(hp);
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.clientSocket == null || this.clientSocket.isClosed() || !this.clientSocket.isConnected();
    }

    public void start() {
        if (this.clientSocket == null) {
            try {
                this.clientSocket = new DatagramSocket();
            }
            catch (SocketException e1) {
                e1.printStackTrace();
            }
            if (this.clientSocket != null) {
                byte[] buf = new byte[8192];
                DatagramPacket rp = new DatagramPacket(buf, 8192);
                while (this.clientSocket != null && !this.clientSocket.isClosed()) {
                    try {
                        this.clientSocket.receive(rp);
                        String content = URLDecoder.decode(new String(rp.getData(), 0, rp.getLength()), "utf-8");
                        if (content.startsWith(ERROR_KEY)) {
                            JDSServer.getClusterClient().login(false);
                            continue;
                        }
                        if (content.startsWith(SUCCESS_KEY)) {
                            if (hearttask == null) continue;
                            hearttask.setLastTime(System.currentTimeMillis());
                            continue;
                        }
                        if (content.startsWith(START_KEY) && content.endsWith(END_KEY)) {
                            JSONObject jsonobj;
                            if (hearttask != null) {
                                hearttask.setLastTime(System.currentTimeMillis());
                            }
                            if ((jsonobj = JSONObject.parseObject((String)content)).containsKey((Object)EVENTKEY) && jsonobj.get((Object)EVENTKEY).equals(1001)) {
                                JDSServer.getClusterClient().reboot();
                                continue;
                            }
                            logger.info("Client &&&&&&&&&&&&&&&&&&&&&& json=" + content);
                            if (!jsonobj.containsKey((Object)"token")) continue;
                            String token = jsonobj.getString("token");
                            if (!msgCache.containsKey(token) && jsonobj.containsKey((Object)"expression")) {
                                if (jsonobj.containsKey((Object)"commandJson")) {
                                    ClusterCommand command = (ClusterCommand)JSONObject.parseObject((String)content, ClusterCommand.class);
                                    udpService.submit(new ClusterExeCMDControl(command));
                                } else if (jsonobj.containsKey((Object)"sourceJson")) {
                                    ClusterEvent event = (ClusterEvent)JSONObject.parseObject((String)content, ClusterEvent.class);
                                    udpService.submit(new ClusterExeEventControl(event));
                                }
                            }
                            this.updateCommandStatus(token, MsgStatus.READED);
                            continue;
                        }
                        logger.info("error [" + content + "]");
                    }
                    catch (Throwable thrown) {
                        thrown.printStackTrace();
                        new Thread(){

                            @Override
                            public void run() {
                                JDSServer.getClusterClient().reboot();
                            }
                        }.start();
                    }
                }
            }
        }
    }

    public void updateEventStatus(String token, MsgStatus status) {
        this.send(STATUS_START_KEY + token + STATUS_SPLIT_KEY + status.getType() + STATUS_END_KEY);
    }

    public void updateCommandStatus(String token, MsgStatus status) {
        this.send(STATUS_START_KEY + token + STATUS_SPLIT_KEY + status.getType() + STATUS_END_KEY);
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public DatagramSocket getClientSocket() {
        return this.clientSocket;
    }

    public void setClientSocket(DatagramSocket clientSocket) {
        this.clientSocket = clientSocket;
    }

    public void updateTaskStatus(String msgId, String status) {
        udpService.submit(new UDPControl(this.user, msgId, status));
    }

    private void fireSeverEvent(SubSystem server, ServerEventEnums eventID, Map eventContext) {
        try {
            ServerEvent<SubSystem> event = new ServerEvent<SubSystem>(server, eventID, JDSServer.getInstance().getCurrServerBean().getId());
            event.setContextMap(eventContext);
            ClusterEventControl.getInstance().dispatchEvent((JDSEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    static {
        logger = LogFactory.getLog("JDS", UDPClient.class);
        clientMap = new HashMap<User, ClusterClient>();
        msgCache = CacheManagerFactory.createCache("org", "msgCache", 0x100000, 60000L);
        cmdService = Executors.newSingleThreadScheduledExecutor(new JDSThreadFactory("UDPClient.cmdService"));
        udpService = Executors.newFixedThreadPool(150, new JDSThreadFactory("UDPClient.udpService"));
        config = new SerializeConfig();
        UDPClient.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

