/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.ds.cluster.udp.HeardInfo;
import com.ds.cluster.udp.UDPClient;
import com.ds.config.JDSConfig;
import com.ds.jds.core.User;
import com.ds.server.JDSServer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HeartThread.class);
    private DatagramSocket ds;
    private User user;
    Long lastHeartTime;
    private static final SerializeConfig config = new SerializeConfig();

    public void setLastTime(Long lastHeartTime) {
        this.lastHeartTime = lastHeartTime;
    }

    public HeartThread(DatagramSocket ds, User user) {
        this.ds = ds;
        this.user = user;
        this.lastHeartTime = System.currentTimeMillis();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void run() {
        try {
            URL url = new URL("http://" + this.user.getUdpIP());
            while (this.ds != null && !this.ds.isClosed()) {
                try {
                    Thread.sleep(5000L);
                    Long interval = System.currentTimeMillis() - this.lastHeartTime;
                    if (interval < 15000L && UDPClient.getInstance().getUser() != null) {
                        HashMap map = new HashMap();
                        HeardInfo heardInfo = new HeardInfo();
                        heardInfo.setSessionId(this.user.getSessionId());
                        heardInfo.setSystemCode(this.user.getSystemCode());
                        heardInfo.setUserid(this.user.getId());
                        String hertStr = JSONObject.toJSON((Object)heardInfo).toString();
                        DatagramPacket hp = new DatagramPacket(URLEncoder.encode(hertStr).getBytes(), URLEncoder.encode(hertStr).length(), InetAddress.getByName(url.getHost()), this.user.getUdpPort());
                        if (this.ds == null || this.ds.isClosed()) continue;
                        this.ds.send(hp);
                        continue;
                    }
                    Boolean self = new Boolean(JDSConfig.getValue("udpServer.self"));
                    if (self != null && self.booleanValue()) continue;
                    new Thread(){

                        @Override
                        public void run() {
                            JDSServer.getClusterClient().reboot();
                        }
                    }.start();
                    this.ds = null;
                }
                catch (Exception e) {
                    this.ds.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DatagramSocket getDs() {
        return this.ds;
    }

    public void setDs(DatagramSocket ds) {
        this.ds = ds;
    }

    public static void main(String[] args) {
        try {
            DatagramSocket clientSocket = new DatagramSocket();
            String hertStr = "testudpdata";
            DatagramPacket hp = new DatagramPacket(URLEncoder.encode("testudpdata").getBytes(), URLEncoder.encode("testudpdata").length(), InetAddress.getByName("www.itjds.net"), 8090);
            clientSocket.send(hp);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        HeartThread.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

