/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.ds.cluster.udp.ClusterEvent;
import com.ds.cluster.udp.UDPClient;
import com.ds.enums.MsgStatus;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.JDSServer;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;

public class ClusterExeEventControl
implements Runnable {
    private final ClusterEvent event;

    ClusterExeEventControl(ClusterEvent event) {
        this.event = event;
    }

    @Override
    public void run() {
        ActionContext.getContext().getContextMap().put("event", this.event);
        if (this.event != null) {
            String msgId = this.event.getMsgId();
            String token = this.event.getToken();
            RuntimeLog log = ConnectionLogFactory.getInstance().createLog(token, "udp://" + JDSServer.getClusterClient().getUDPClient().getUser().getUdpIP() + ":[" + this.event.getSystemCode() + "]", this.event.getEventName() + "[" + this.event.getEventId() + "]", msgId);
            log.setStartTime(this.event.getSendTime());
            log.setBodyJson(this.event.getSourceJson());
            log.setArrivedTime(System.currentTimeMillis());
            log.setTime(log.getArrivedTime() - log.getStartTime());
            log.setStatus(MsgStatus.UPDATE);
            Object obj = EsbUtil.parExpression(this.event.getExpression());
            log.setEndTime(System.currentTimeMillis());
            if (obj != null && Boolean.valueOf(obj.toString()).booleanValue()) {
                log.setStatus(MsgStatus.READED);
                log.setExetime(log.getEndTime() - log.getArrivedTime());
                UDPClient.getInstance().updateEventStatus(this.event.getToken(), MsgStatus.UPDATE);
            } else {
                log.setStatus(MsgStatus.ERROR);
                log.setExetime(log.getEndTime() - log.getArrivedTime());
                UDPClient.getInstance().updateEventStatus(this.event.getToken(), MsgStatus.ERROR);
            }
        }
    }
}

