/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.ServerBeanManager;
import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.cluster.event.ClusterEventControl;
import com.ds.cluster.event.ServerEvent;
import com.ds.cluster.udp.ClusterClient;
import com.ds.cluster.udp.UDPClient;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.AppConfig;
import com.ds.config.CApplication;
import com.ds.config.JDSConfig;
import com.ds.config.UserBean;
import com.ds.engine.event.JDSEvent;
import com.ds.enums.ServerEventEnums;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.ServerStatus;
import com.ds.server.SubSystem;
import com.ds.server.ct.CtSubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.xml.sax.InputSource;

public class ClusterClientImpl
implements ClusterClient {
    private UDPClient udpClient;
    private static final String SYSCODE = "SYSCODE";
    private Map<String, SubSystem> systemInfoCache = new HashMap<String, SubSystem>();
    private List<String> systemIds;
    private static Map<ConfigCode, ServerNodeList> serverNodeListMap = new HashMap<ConfigCode, ServerNodeList>();
    public static final String APPLICATION_GETALLSYSTEMURL = "/api/sys/GetAllSystemInfo";
    public static final String APPLICATION_GETSYSTEMSTATUS = "/api/sys/getAllSystemStatus";
    public static final String APPLICATION_GETSERVERS = "/api/sys/GetAllSystemBeanList";
    public static final String APPLICATION_GETAPPCONFIG = "/api/sys/GetAppLications";
    public static final String APPLICATION_CONFIGFILE_NAME = "application_config.xml";
    public static final String APPLICATION_SERVERCONFIG_NAME = "server_config.xml";
    public static final String GetSubSystemInfoURL = "/api/sys/getSubSystemInfo";
    private Long lasterUpdateTime;
    Map<String, ServerStatus> statusMap = new HashMap<String, ServerStatus>();
    private static final Log logger = LogFactory.getLog("JDS", ClusterClientImpl.class);
    private static ConcurrentMap<ConfigCode, CApplication> applicationMap = new ConcurrentHashMap<ConfigCode, CApplication>();
    private static ConcurrentMap<String, CApplication> sysCodeApplicationMap = new ConcurrentHashMap<String, CApplication>();

    public ClusterClientImpl() {
        this.udpClient = UDPClient.getInstance();
    }

    @Override
    public void start() {
        try {
            this.initCluster();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                ClusterClientImpl.this.udpClient.start();
            }
        }.start();
    }

    @Override
    public UDPClient getUDPClient() {
        return UDPClient.getInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void initCluster() throws JDSException {
        this.systemIds = new ArrayList<String>();
        if (!UserBean.getInstance().getConfigName().equals(OrgConstants.CLUSTERCONFIG_KEY)) {
            this.systemIds = this.getRemoteAllSystem();
            List<CApplication> applications = this.getRemoteAppLications();
            for (CApplication application : applications) {
                applicationMap.put(ConfigCode.fromType(application.getConfigCode()), application);
                ServerNodeList beanList = ClusterClientImpl.getRemoteServerNodeList(ConfigCode.fromType(application.getConfigCode()));
                if (beanList == null) continue;
                serverNodeListMap.put(ConfigCode.fromType(application.getConfigCode()), ClusterClientImpl.getRemoteServerNodeList(ConfigCode.fromType(application.getConfigCode())));
            }
        } else {
            List<SubSystem> eisystems = OrgManagerFactory.getInstance().getSystems();
            for (SubSystem subSystem : eisystems) {
                if (subSystem == null || subSystem.getSysId() == null) continue;
                this.systemInfoCache.put(subSystem.getSysId(), new CtSubSystem(subSystem));
                this.systemIds.add(subSystem.getSysId());
            }
        }
        for (String systemId : this.systemIds) {
            SubSystem system = this.getRemoteSystem(systemId);
            try {
                CApplication application;
                logger.info("initSubSystem cluster configname[" + system.getName() + "]");
                HashMap<String, String> eventContext = new HashMap<String, String>();
                eventContext.put(SYSCODE, system.getSysId());
                if (UserBean.getInstance().getConfigName().equals(OrgConstants.CLUSTERCONFIG_KEY)) {
                    application = (CApplication)applicationMap.get(system.getConfigname());
                    if (application == null) {
                        application = this.initSubSystem(system);
                        if (application == null) throw new JDSException("Application '" + system.getConfigname() + "' not found!", 1001);
                        applicationMap.put(system.getConfigname(), application);
                    } else {
                        this.initSubSystem(system);
                    }
                    sysCodeApplicationMap.put(system.getSysId(), application);
                } else {
                    this.initRemoteSystemConfig(system.getConfigname(), system);
                    application = (CApplication)applicationMap.get(system.getConfigname());
                    if (application != null) {
                        sysCodeApplicationMap.put(system.getSysId(), (CApplication)applicationMap.get(system.getConfigname()));
                    }
                }
                this.systemInfoCache.put(system.getSysId(), system);
            }
            catch (JDSException e) {
                logger.error("initSubSystem error configname[" + system.getConfigname() + "]");
            }
        }
    }

    public String getApplicationConfig(String sysCode) throws JDSException {
        File appConfigFile;
        File appHome = new File(JDSConfig.Config.applicationHome().getAbsolutePath() + File.separator + sysCode);
        if (appHome.exists() && (appConfigFile = new File(appHome, APPLICATION_CONFIGFILE_NAME)).exists()) {
            BufferedReader br = null;
            try {
                String xml;
                String str;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(appConfigFile), "utf-8"));
                StringBuffer sb = new StringBuffer();
                while ((str = br.readLine()) != null) {
                    sb.append(str);
                }
                String string = xml = sb.toString();
                return string;
            }
            catch (IOException fnfe) {
                logger.error("Load config file for application " + sysCode + " fail.", fnfe);
                throw new JDSException("ErrorCannotGetAppConfig");
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private List<CApplication> getRemoteAppLications() throws JDSException {
        String url = APPLICATION_GETAPPCONFIG;
        Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url));
        Future future = Async.newInstance().execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
        ArrayList<CApplication> applications = new ArrayList();
        String json = "";
        try {
            json = ((Content)future.get()).asString();
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status != 0) {
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u61c9\u7528\u914d\u7f6e\u4fe1\u606f\uff01");
            }
            String data = jsonObj.getString("data");
            applications = JSONArray.parseArray((String)data, CApplication.class);
        }
        catch (Exception e) {
            throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u61c9\u7528\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        return applications;
    }

    private List<String> getRemoteAllSystem() throws JDSException {
        ArrayList<String> systems;
        block4: {
            String url = APPLICATION_GETALLSYSTEMURL;
            logger.info("getRemoteAllSystem:" + UserBean.getInstance().getServerUrl() + url);
            Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url));
            Future future = Async.newInstance().execute(request, (FutureCallback)new FutureCallback<Content>(){

                public void failed(Exception ex) {
                    ex.printStackTrace();
                }

                public void completed(Content content) {
                }

                public void cancelled() {
                }
            });
            systems = new ArrayList<String>();
            String json = "";
            try {
                json = ((Content)future.get()).asString();
                JSONObject jsonObj = JSONObject.parseObject((String)json);
                Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
                if (status == 0) {
                    String data = jsonObj.getString("data");
                    List eisystems = JSONArray.parseArray((String)data, CtSubSystem.class);
                    for (SubSystem subSystem : eisystems) {
                        this.systemInfoCache.put(subSystem.getSysId(), subSystem);
                        systems.add(subSystem.getSysId());
                    }
                    break block4;
                }
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01" + UserBean.getInstance().getServerUrl() + url);
            }
        }
        return systems;
    }

    void initRemoteSystemConfig(ConfigCode appCode, SubSystem system) throws JDSException {
        Set<String> it;
        ServerNodeList serverBeanList = serverNodeListMap.get(appCode);
        if (serverBeanList == null) {
            serverBeanList = ClusterClientImpl.getRemoteServerNodeList(appCode);
            serverNodeListMap.put(appCode, serverBeanList);
        }
        if (serverBeanList != null && !(it = serverBeanList.getEsbBeanMap().keySet()).contains(system.getSysId())) {
            ServerNode serverBean = new ServerNode(system);
            serverBeanList.getEsbBeanMap().put(system.getSysId(), serverBean);
        }
    }

    @Override
    public void login(Boolean init) {
        if (init.booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ClusterClientImpl.this.udpClient.login();
                }
            }.start();
        } else {
            this.udpClient.login();
        }
    }

    @Override
    public void login() {
        this.login(true);
    }

    @Override
    public void reboot() {
        this.udpClient.stop();
        new Thread(){

            @Override
            public void run() {
                ClusterClientImpl.this.start();
                ClusterClientImpl.this.udpClient.login();
            }
        }.start();
    }

    @Override
    public void reLoadConfig() {
        try {
            this.initCluster();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ServerNode> getAllServer() {
        ArrayList<ServerNode> servers = new ArrayList<ServerNode>();
        Map<String, ServerNode> besnmap = this.getAllServerMap();
        Set<String> keyset = besnmap.keySet();
        for (String key : keyset) {
            ServerNode severBean = besnmap.get(key);
            if (severBean == null) continue;
            servers.add(besnmap.get(key));
        }
        return servers;
    }

    @Override
    public ServerNode getServerNodeById(String nodeId) {
        SubSystem subSystem;
        ServerNode node = this.getAllServerMap().get(nodeId);
        if (node == null && (subSystem = this.getSystem(nodeId)) != null) {
            node = new ServerNode(subSystem);
            this.getAllServerMap().put(nodeId, node);
        }
        return node;
    }

    @Override
    public ServerNodeList getServerNodeListByConfigCode(ConfigCode code) {
        return serverNodeListMap.get(code);
    }

    private static ServerNodeList getRemoteServerNodeList(ConfigCode code) throws JDSException {
        String url = APPLICATION_GETSERVERS;
        Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url + "?code=" + code.getType()));
        Future future = Async.newInstance().execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
        ServerNodeList serverBeanList = new ServerNodeList();
        String json = "";
        try {
            json = ((Content)future.get()).asString();
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status != 0) {
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u61c9\u7528\u914d\u7f6e\u4fe1\u606f\uff01");
            }
            String data = jsonObj.getString("data");
            serverBeanList = (ServerNodeList)JSONObject.parseObject((String)data, ServerNodeList.class);
        }
        catch (Exception e) {
            throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u61c9\u7528\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        return serverBeanList;
    }

    private SubSystem loadRemoteSystem(String systemCode) throws JDSException {
        String url = GetSubSystemInfoURL;
        Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url + "?systemCode=" + systemCode));
        Future future = Async.newInstance().execute(request);
        SubSystem system = null;
        String json = "";
        try {
            json = ((Content)future.get()).asString();
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status != 0) {
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01");
            }
            String data = jsonObj.getString("data");
            system = (SubSystem)JSONObject.parseObject((String)data, SubSystem.class);
        }
        catch (Exception e) {
            throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\uff01");
        }
        return system;
    }

    public List<SubSystem> getRemoteSystems() {
        ArrayList<SubSystem> subSystems = new ArrayList<SubSystem>();
        for (String systemId : this.systemIds) {
            subSystems.add(this.getRemoteSystem(systemId));
        }
        return subSystems;
    }

    public SubSystem getRemoteSystem(String systemId) {
        SubSystem system = this.systemInfoCache.get(systemId);
        if (system == null) {
            try {
                SubSystem remoteSystem = this.loadRemoteSystem(systemId);
                if (remoteSystem != null) {
                    system = new CtSubSystem(remoteSystem);
                    this.systemInfoCache.put(systemId, system);
                }
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return system;
    }

    public CApplication initSubSystem(SubSystem system) throws JDSException {
        File applicationConfigFile;
        String path;
        File applicationPath;
        ConfigCode syscode = system.getConfigname();
        CApplication app = null;
        if (syscode == null) {
            syscode = ConfigCode.fromType("JDS");
        }
        if ((applicationPath = new File(path = JDSConfig.Config.applicationHome().getAbsolutePath() + File.separator + syscode.getType())).isDirectory() && (applicationConfigFile = new File(applicationPath, APPLICATION_CONFIGFILE_NAME)).exists() && applicationConfigFile.isFile()) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(applicationConfigFile), "utf-8");
                InputSource is = new InputSource(reader);
                AppConfig appConfig = new AppConfig(is);
                ((Reader)reader).close();
                app = appConfig.getApplication();
                app.setConfigPath(system.getConfigname().getType());
                if (app != null && app.getName() != null) {
                    logger.info("Application " + app.getName() + " loaded.");
                    File applicationServerConfigFile = new File(applicationPath, APPLICATION_SERVERCONFIG_NAME);
                    if (applicationServerConfigFile.exists() && applicationServerConfigFile.isFile()) {
                        ServerNodeList serverBeanList = ServerBeanManager.getEsbBeanList(applicationServerConfigFile.getAbsolutePath(), system);
                        serverNodeListMap.put(ConfigCode.fromType(app.getConfigCode()), serverBeanList);
                        Set<String> it = serverBeanList.getEsbBeanMap().keySet();
                        if (!it.contains(system.getSysId())) {
                            ServerNode serverBean = new ServerNode(system);
                            serverBeanList.getEsbBeanMap().put(system.getSysId(), serverBean);
                        }
                    }
                }
            }
            catch (Exception me) {
                throw new JDSException("Failed to load config file " + applicationConfigFile.getAbsolutePath(), me, 22);
            }
        }
        return app;
    }

    @Override
    public Map<String, ServerNode> getAllServerMap() {
        HashMap<String, ServerNode> serverMap = new HashMap<String, ServerNode>();
        Set<ConfigCode> ketSet = serverNodeListMap.keySet();
        for (ConfigCode code : ketSet) {
            ServerNodeList beanList = serverNodeListMap.get(code);
            if (beanList == null) continue;
            Map<String, ServerNode> beanmap = beanList.getEsbBeanMap();
            serverMap.putAll(beanmap);
        }
        return serverMap;
    }

    @Override
    public CApplication getApplication(ConfigCode systemCode) {
        return (CApplication)applicationMap.get(systemCode);
    }

    @Override
    public Map<ConfigCode, CApplication> getApplicationMap() {
        return applicationMap;
    }

    @Override
    public List<CApplication> getApplications() {
        ArrayList<CApplication> applications = new ArrayList<CApplication>();
        ConcurrentMap<ConfigCode, CApplication> besnmap = applicationMap;
        Set keyset = besnmap.keySet();
        for (ConfigCode key : keyset) {
            CApplication application = (CApplication)besnmap.get(key);
            if (application == null) continue;
            applications.add((CApplication)besnmap.get(key));
        }
        return applications;
    }

    @Override
    public SubSystem getSystem(String systemCode) {
        return this.getRemoteSystem(systemCode);
    }

    @Override
    public List<SubSystem> getAllSystem() {
        return this.getRemoteSystems();
    }

    @Override
    public synchronized SystemStatus getSystemStatus(String systemCode) {
        try {
            String url = APPLICATION_GETSYSTEMSTATUS;
            if (this.lasterUpdateTime == null || System.currentTimeMillis() - this.lasterUpdateTime > 60000L) {
                this.statusMap.clear();
                Request request = Request.Post((String)(UserBean.getInstance().getServerUrl() + url + "?sysCode=" + systemCode));
                Future future = Async.newInstance().execute(request);
                String json = ((Content)future.get()).asString();
                JSONObject jsonObj = JSONObject.parseObject((String)json);
                Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
                if (status == 0) {
                    String data = jsonObj.getString("data");
                    List serverStatusList = JSONArray.parseArray((String)data, ServerStatus.class);
                    for (ServerStatus serverStatus : serverStatusList) {
                        this.statusMap.put(serverStatus.getId(), serverStatus);
                    }
                }
                this.lasterUpdateTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.error("getSystemStatus  sysCoxde");
            e.printStackTrace();
        }
        ServerStatus serverStatus = this.statusMap.get(systemCode);
        if (serverStatus != null) {
            return serverStatus.getStatus();
        }
        return SystemStatus.OFFLINE;
    }

    @Override
    public Person getAdminPerson(String systemCode) {
        try {
            Person person = null;
            if (this.getSystem(systemCode) != null) {
                String adminId = this.getSystem(systemCode).getAdminId();
                person = adminId != null ? OrgManagerFactory.getOrgManager().getPersonByAccount(adminId) : OrgManagerFactory.getOrgManager().getPersonByAccount(this.getSystem(systemCode).getSysId() + this.getSystem(systemCode).getName());
            }
            return person;
        }
        catch (PersonNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getServerConfig(String sysCode) throws JDSException {
        File appHome = new File(JDSConfig.Config.applicationHome().getAbsolutePath() + File.separator + sysCode);
        File appConfigFile = new File(appHome, APPLICATION_SERVERCONFIG_NAME);
        BufferedReader br = null;
        try {
            String xml;
            String str;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(appConfigFile), "utf-8"));
            StringBuffer sb = new StringBuffer();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            String string = xml = sb.toString();
            return string;
        }
        catch (IOException fnfe) {
            logger.error("Load config file for application " + sysCode + " fail.", fnfe);
            throw new JDSException("ErrorCannotGetAppConfig");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void updateTaskStatus(String id, String readed) {
    }

    @Override
    public boolean isLogin() {
        return false;
    }

    @Override
    public boolean send(String msgStr) {
        return this.udpClient.send(msgStr);
    }

    @Override
    public void stop() {
        this.udpClient = UDPClient.getInstance();
        new Thread(){

            @Override
            public void run() {
                ClusterClientImpl.this.udpClient.stop();
            }
        }.start();
    }

    private void fireSeverEvent(SubSystem server, ServerEventEnums eventID, Map eventContext) {
        try {
            ServerEvent<SubSystem> event = new ServerEvent<SubSystem>(server, eventID, JDSServer.getInstance().getCurrServerBean().getId());
            event.setContextMap(eventContext);
            ClusterEventControl.getInstance().dispatchEvent((JDSEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

