/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.event.RegistEventBean;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.UserBean;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.jds.core.User;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSServer;
import com.ds.web.RemoteConnectionManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.concurrent.FutureCallback;

public class ServerEventFactory {
    private static ServerEventFactory instance;
    public static final String THREAD_LOCK = "Thread Lock";
    private String serverUrl;
    private Map<String, Set<? extends ServiceBean>> repeatEventCache = new HashMap<String, Set<? extends ServiceBean>>();
    private Map<String, ServiceBean> eventServiceBean = new HashMap<String, ServiceBean>();
    public static final String APPLICATION_REGISTEREVENT = "/api/sys/registerEvent";
    public static final String APPLICATION_REGISTERJSONEVENT = "/api/sys/registerEventJSON";
    public static final String APPLICATION_CLEAREVENTKEYS = "/api/sys/clearEventKeys";
    public static final String APPLICATION_REMOVEENENT = "/api/sys/removeEvent";
    public static Integer udpEventPort;
    public static final String APPLICATION_GETALLREGISTEREVENT = "/api/sys/getAllRegisterEvent";
    public static final String APPLICATION_GETREGISTEREVENTBYCODE = "/api/sys/getRegisterEventByCode";
    private static final Log logger;
    int times = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerEventFactory getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new ServerEventFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initEvent(User user) throws JDSException {
        if (!UserBean.getInstance().getConfigName().equals(OrgConstants.UDPCONFIG_KEY)) {
            String udpUrl = UserBean.getInstance().getUdpUrl();
            if (udpUrl != null && !udpUrl.equals("")) {
                this.serverUrl = udpUrl;
            } else {
                String url = UserBean.getInstance().getServerUrl();
                if ((url = url.substring("http://".length())).indexOf(":") > -1) {
                    udpEventPort = Integer.valueOf(url.split(":")[1]);
                }
                this.serverUrl = "http://" + user.getUdpIP() + ":" + udpEventPort;
            }
            this.clearEvent();
            try {
                this.registerJSONEvent(this.getLocalRegisterEvent());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    List<? extends ServiceBean> reLoadServerEvent(String sysCode) {
        String url = APPLICATION_GETREGISTEREVENTBYCODE;
        List serviceBeans = new ArrayList();
        Request request = Request.Post((String)(this.serverUrl + url));
        request.setHeader("Connection", "close");
        Form form = Form.form();
        form.add("sysCode", sysCode);
        request.bodyForm((Iterable)form.build(), Charset.forName("utf-8"));
        try {
            Response response = request.execute();
            JSONObject jsonObj = JSONObject.parseObject((String)response.returnContent().asString());
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status == 0) {
                String data = jsonObj.getString("data");
                serviceBeans = JSONArray.parseArray((String)data, ExpressionTempBean.class);
                for (ServiceBean serviceBean : serviceBeans) {
                    this.eventServiceBean.put(serviceBean.getId(), serviceBean);
                }
            }
        }
        catch (IOException e) {
            logger.warn("http failed[/api/sys/getRegisterEventByCode] currentThread=" + Thread.currentThread().getId());
            e.printStackTrace();
        }
        return serviceBeans;
    }

    void reload() throws JDSException {
        block5: {
            String url = APPLICATION_GETALLREGISTEREVENT;
            Request request = Request.Post((String)(this.serverUrl + url));
            request.setHeader("Connection", "close");
            Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(this.serverUrl));
            Future future = async.execute(request);
            try {
                String json = ((Content)future.get()).asString();
                JSONObject jsonObj = JSONObject.parseObject((String)json);
                Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
                if (status == 0) {
                    String data = jsonObj.getString("data");
                    List serverEventBeans = JSONArray.parseArray((String)data, RegistEventBean.class);
                    for (RegistEventBean serverEventBean : serverEventBeans) {
                        Set<ExpressionTempBean> serviceBeans = serverEventBean.getEventService();
                        for (ServiceBean serviceBean : serviceBeans) {
                            this.eventServiceBean.put(serviceBean.getId(), serviceBean);
                        }
                        this.repeatEventCache.put(serverEventBean.getSysCode(), serverEventBean.getEventService());
                    }
                    break block5;
                }
                throw new JDSException("\u65e0\u6cd5\u83b7\u53d6\u6ce8\u518c\u4e8b\u4ef6\u96c6\u5408");
            }
            catch (Exception e) {
                logger.warn("\u672a\u53d1\u73b05.1\uff0c\u5e94\u7528\u8fdb\u5165\u517c\u5bb9\u6a21\u5f0f...");
                logger.warn("\u8be5\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u5b8c\u6210\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u90e8\u5206\u4e8b\u4ef6\u529f\u80fd\uff01");
                e.printStackTrace();
            }
        }
    }

    public ServiceBean getServiceBeanById(String serviceId) {
        ServiceBean serviceBean = this.eventServiceBean.get(serviceId);
        if (serviceBean == null) {
            serviceBean = EsbBeanFactory.getInstance().getEsbBeanById(serviceId);
            this.eventServiceBean.put(serviceId, serviceBean);
        }
        return serviceBean;
    }

    public void clearEvent() throws JDSException {
        String url = APPLICATION_CLEAREVENTKEYS;
        Request request = Request.Post((String)(this.serverUrl + url));
        request.setHeader("Connection", "close");
        Form form = Form.form();
        form.add("systemCode", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("SYSID", JDSServer.getInstance().getCurrServerBean().getId());
        request.bodyForm((Iterable)form.build(), Charset.forName("utf-8"));
        Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(this.serverUrl));
        Future future = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                logger.warn("http failed[/api/sys/clearEventKeys] currentThread=" + Thread.currentThread().getId());
                logger.warn("\u4e8b\u4ef6\u6e05\u7a7a\u5931\u8d25\uff0c\u517c\u5bb9\u6027\u9519\u8bef");
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
    }

    public void removeEvent(String serviceKey) throws JDSException {
        String url = APPLICATION_REMOVEENENT;
        Request request = Request.Post((String)(this.serverUrl + url));
        request.setHeader("Connection", "close");
        Form form = Form.form();
        form.add("systemCode", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("SYSID", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("eventKey", serviceKey);
        form.add("JSESSIONID", JDSServer.getInstance().getAdminUser().getSessionId());
        request.bodyForm((Iterable)form.build(), Charset.forName("UTF-8"));
        Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(this.serverUrl));
        Future future = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                logger.warn("\u4e8b\u4ef6\u79fb\u9664\u5931\u8d25");
                ex.printStackTrace();
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
    }

    public void registerJSONEvent(List<? extends ServiceBean> msgEvent) throws JDSException, IOException {
        String url = APPLICATION_REGISTERJSONEVENT;
        ++this.times;
        Request request = Request.Post((String)(this.serverUrl + url));
        request.setHeader("Connection", "close");
        Form form = Form.form();
        form.add("systemCode", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("json", JSON.toJSONString(msgEvent));
        form.add("SYSID", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("JSESSIONID", JDSServer.getInstance().getAdminUser().getSessionId());
        request.bodyForm((Iterable)form.build(), Charset.forName("UTF-8"));
        Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(this.serverUrl));
        try {
            Future content = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

                public void failed(Exception ex) {
                    logger.warn("http failed[/api/sys/registerEventJSON] currentThread=" + Thread.currentThread().getId());
                    logger.warn("\u4e8b\u4ef6\u6e05\u7a7a\u5931\u8d25\uff0c\u517c\u5bb9\u6027\u9519\u8bef");
                }

                public void completed(Content content) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                                ServerEventFactory.this.reload();
                            }
                            catch (JDSException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }

                public void cancelled() {
                }
            });
            String json = ((Content)content.get()).asString();
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status != 0) {
                throw new JDSException("\u6ce8\u518c\u96c6\u7fa4\u76d1\u542c\u5668\u5931\u8d25\uff01");
            }
            String string = jsonObj.getString("data");
        }
        catch (Exception e) {
            if (this.times < 100) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.registerJSONEvent(msgEvent);
            }
            this.registerEvent(msgEvent);
        }
    }

    public void registerEvent(List<? extends ServiceBean> msgEvent) throws JDSException {
        String url = APPLICATION_REGISTEREVENT;
        Request request = Request.Post((String)(this.serverUrl + url));
        request.setHeader("Connection", "close");
        Form form = Form.form();
        form.add("systemCode", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("SYSID", JDSServer.getInstance().getCurrServerBean().getId());
        form.add("JSESSIONID", JDSServer.getInstance().getAdminUser().getSessionId());
        StringBuffer keyBuffer = new StringBuffer();
        for (ServiceBean serviceBean : msgEvent) {
            keyBuffer.append("$" + serviceBean.getId() + ";");
        }
        form.add("eventKey", keyBuffer.toString());
        request.bodyForm((Iterable)form.build(), Charset.forName("UTF-8"));
        Async async = Async.newInstance().use((Executor)RemoteConnectionManager.getConntctionService(this.serverUrl));
        Future future = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                logger.warn("http failed[/api/sys/registerEvent] currentThread=" + Thread.currentThread().getId());
                ex.printStackTrace();
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
        String json = "";
        try {
            json = ((Content)future.get()).asString();
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            Integer status = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            if (status != 0) {
                throw new JDSException("\u6ce8\u518c\u96c6\u7fa4\u76d1\u542c\u5668\u5931\u8d25\uff01");
            }
            String string = jsonObj.getString("data");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JDSException("\u6ce8\u518c\u96c6\u7fa4\u76d1\u542c\u5668\u5931\u8d25\uff01");
        }
    }

    public List<? extends ServiceBean> getLocalRegisterEvent() {
        return EsbBeanFactory.getInstance().getServiceBeanByFlowType(EsbFlowType.msgRepeat);
    }

    public Set<ExpressionTempBean> getAllRegisterEvent() {
        LinkedHashSet<ExpressionTempBean> serviceSet = new LinkedHashSet<ExpressionTempBean>();
        LinkedHashSet<String> serviceIdSet = new LinkedHashSet<String>();
        Set<String> codeSet = this.repeatEventCache.keySet();
        for (String sysCode : codeSet) {
            Set<? extends ServiceBean> codeSetBeans = this.repeatEventCache.get(sysCode);
            for (ExpressionTempBean expressionTempBean : codeSetBeans) {
                if (serviceIdSet.contains(expressionTempBean.getId())) continue;
                serviceIdSet.add(expressionTempBean.getId());
                serviceSet.add(expressionTempBean);
            }
        }
        return serviceSet;
    }

    public List<ExpressionTempBean> getRegisterEventByCode(String sysCode) {
        List<Object> serviceBeans = new ArrayList();
        if (sysCode == null || sysCode.equals("-all-")) {
            serviceBeans = this.getLocalRegisterEvent();
        } else {
            Set<? extends ServiceBean> eventKeys = this.repeatEventCache.get(sysCode);
            if (eventKeys == null) {
                eventKeys = new LinkedHashSet<ServiceBean>();
                serviceBeans = this.reLoadServerEvent(sysCode);
                if (serviceBeans != null) {
                    for (ServiceBean serviceBean : serviceBeans) {
                        eventKeys.add((ExpressionTempBean)serviceBean);
                        EsbBeanFactory.getInstance().registerService(sysCode, serviceBean);
                    }
                    this.repeatEventCache.put(sysCode, eventKeys);
                }
            } else {
                for (ExpressionTempBean expressionTempBean : eventKeys) {
                    if (expressionTempBean == null) continue;
                    serviceBeans.add(expressionTempBean);
                }
            }
        }
        return serviceBeans;
    }

    static {
        udpEventPort = 8090;
        logger = LogFactory.getLog("JDS", ServerEventFactory.class);
    }
}

