/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.event;

import com.ds.cluster.ServerNode;
import com.ds.cluster.event.ClusterEventControl;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esb.config.EsbFlowType;
import com.ds.server.JDSServer;

@EsbBeanAnnotation(id="RepeatClusterEvent", name="\u8f6c\u53d1Cluster\u96c6\u7fa4\u4e8b\u4ef6", flowType=EsbFlowType.msgRepeat, expressionArr="RepeatClusterEvent(event)", desc="\u8f6c\u53d1Cluster\u96c6\u7fa4\u4e8b\u4ef6")
public class RepeatClusterEvent
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog("JDS", RepeatClusterEvent.class);

    public Boolean perform(ClusterEvent event) {
        logger.info("client satrt repeat event" + event.getSourceJson());
        try {
            String eventId = event.getEventId();
            String content = event.getSourceJson();
            String eventName = event.getEventName();
            String systemCode = event.getSystemCode();
            ServerNode currServerBean = JDSServer.getInstance().getCurrServerBean();
            ClusterEventControl.getInstance().dispatchClusterEvent(content, eventName, eventId, systemCode);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

