/*
 * Decompiled with CFR 0.152.
 */
package com.ds.client;

import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;
import java.util.Map;
import java.util.UUID;

public class JDSSessionFactory {
    private JDSContext context;

    public JDSSessionFactory(JDSContext context) {
        if (context == null) {
            context = JDSActionContext.getActionContext();
        }
        this.context = context;
    }

    public JDSSessionHandle getSessionHandle() {
        Map session = this.context.getSession();
        String sessionId = this.context.getSessionId();
        Cache<String, JDSSessionHandle> sessionHandleCache = null;
        try {
            sessionHandleCache = JDSServer.getInstance().getSessionHandleCache();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        JDSSessionHandle sessionHandle = (JDSSessionHandle)sessionHandleCache.get(sessionId);
        if (sessionHandle == null) {
            if (session.get("sessionHandle") != null) {
                sessionHandle = (JDSSessionHandle)session.get("sessionHandle");
            } else {
                sessionHandle = JDSSessionFactory.newSessionHandle();
                session.put("sessionHandle", sessionHandle);
            }
            sessionHandleCache.put(sessionId, sessionHandle);
        }
        return sessionHandle;
    }

    private static JDSSessionHandle newSessionHandle() {
        String sessionId = UUID.randomUUID().toString();
        Cache<String, JDSSessionHandle> sessionHandleCache = null;
        try {
            sessionHandleCache = JDSServer.getInstance().getSessionHandleCache();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        JDSSessionHandle handle = new JDSSessionHandle(sessionId);
        sessionHandleCache.put(sessionId, handle);
        return handle;
    }

    public static JDSSessionHandle newSessionHandle(String sessionId) {
        Cache<String, JDSSessionHandle> sessionHandleCache = null;
        try {
            sessionHandleCache = JDSServer.getInstance().getSessionHandleCache();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        JDSSessionHandle handle = (JDSSessionHandle)sessionHandleCache.get(sessionId);
        if (handle == null) {
            handle = new JDSSessionHandle(sessionId);
            sessionHandleCache.put(sessionId, handle);
        }
        return handle;
    }

    public JDSSessionHandle createSessionHandle() {
        JDSSessionHandle sessionHandle = JDSSessionFactory.newSessionHandle();
        Cache<String, JDSSessionHandle> sessionHandleCache = null;
        try {
            sessionHandleCache = JDSServer.getInstance().getSessionHandleCache();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        Map session = this.context.getSession();
        String sessionId = this.context.getSessionId();
        session.put("sessionHandle", sessionHandle);
        sessionHandleCache.put(sessionId, sessionHandle);
        return sessionHandle;
    }

    public JDSSessionHandle getSessionHandleBySessionId(String sessionId) {
        Cache<String, JDSSessionHandle> sessionHandleCache = null;
        try {
            sessionHandleCache = JDSServer.getInstance().getSessionHandleCache();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        JDSSessionHandle sessionHandle = (JDSSessionHandle)sessionHandleCache.get(sessionId);
        return sessionHandle;
    }

    public JDSClientService getJDSClientBySessionId(String sessionId, ConfigCode configCode) throws JDSException {
        JDSSessionHandle sessionHandle = this.getSessionHandleBySessionId(sessionId);
        JDSClientService client = null;
        if (sessionHandle != null) {
            client = this.getClientService(sessionHandle, configCode);
        }
        return client;
    }

    public JDSClientService newClientService(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        JDSClientService client = JDSServer.getInstance().newJDSClientService(sessionHandle, configCode);
        return client;
    }

    private JDSClientService getClientService(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        JDSClientService service = JDSServer.getInstance().getJDSClientService(sessionHandle, configCode);
        return service;
    }

    public JDSClientService getClientService(ConfigCode configCode) throws JDSException {
        JDSSessionHandle sessionHandle;
        JDSClientService client = null;
        if (this.context == null) {
            this.context = JDSActionContext.getActionContext();
        }
        if (configCode == null) {
            configCode = this.context.getConfigCode();
        }
        if ((sessionHandle = this.getSessionHandle()) == null) {
            throw new JDSException("Session not available!");
        }
        client = JDSServer.getInstance().getJDSClientService(sessionHandle, configCode);
        return client;
    }
}

