package com.ds.web.json;

import com.ds.config.JDSUtil;
import com.ds.context.JDSActionContext;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.jds.core.esb.EsbUtil;
import org.mvel2.templates.TemplateRuntime;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

@EsbBeanAnnotation(id = "MVEL")
public class MVELUtil {

    public Object par(String experssion) {
        return EsbUtil.parExpression(experssion);
    }


    public Object eval(String experssion) {
        Map context = JDSActionContext.getActionContext().getContext();
        Object object = TemplateRuntime.eval(experssion, context);
        return object;
    }

    public Object evalFile(String fileName) {
        Object object = null;
        try {
            Path path = Paths.get(JDSUtil.getJdsRealPath(), fileName);
            object = TemplateRuntime.eval(new FileInputStream(path.toFile()));

        } catch (IOException e) {
            e.printStackTrace();
        }
        return object;
    }

}
