package com.ds.web.client;


import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.JDSBusException;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import com.ds.server.JDSServer;

import java.util.*;

public class RemoteTempXMLProxy implements ServiceConfigManager {
    private static final Log logger = LogFactory.getLog(
            JDSConstants.CONFIG_KEY, RemoteTempXMLProxy.class);

    private final EsbBean esbBean;

    public RemoteTempXMLProxy(EsbBean esbBean) {
        this.esbBean = esbBean;
        this.esbBean.setEsbtype(EsbBeanType.Cluster);
    }

    List<ServiceBean> remoteBeans = new ArrayList<ServiceBean>();

    Map<String, ServiceBean> remoteBeanMap = new HashMap<String, ServiceBean>();

    Map<String, ServiceBean> nameBeanMap = new HashMap<String, ServiceBean>();

    @Override
    public ServiceBean getServiceConfigById(String id) {
        return remoteBeanMap.get(id);
    }

    @Override
    public ServiceBean getServiceConfigByName(String name) {
        return nameBeanMap.get(name);
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapByName() {
        return remoteBeanMap;
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapById() {
        return remoteBeanMap;
    }

    @Override
    public List<ServiceBean> loadAllService() {
        return remoteBeans;
    }

    @Override
    public Set<Class<?>> init() throws JDSBusException {
        try {
            List<ExpressionTempBean> remoteTempBeans = JDSServer.getInstance().getClusterSevice();
            for (ExpressionTempBean bean : remoteTempBeans) {
                bean.setFlowType(EsbFlowType.clusterAction);
                remoteBeans.add(bean);
                remoteBeanMap.put(bean.getId(), bean);
                nameBeanMap.put(bean.getName(), bean);
            }
        } catch (JDSException e) {
            e.printStackTrace();
        }
        return null;
    }
}