package com.ds.web.annotation;

import com.ds.enums.Enumstype;

import java.util.HashSet;
import java.util.Set;

public enum ViewType implements Enumstype {
    frame("框架", "spafont spa-icon-c-databinder", ViewGroupType.nav),
    nav("导航", "spafont spa-icon-shukongjian", ViewGroupType.nav),
    layout("布局", "spafont spa-icon-c-buttonviews", ViewGroupType.nav),
    grid("列表", "spafont spa-icon-c-grid", ViewGroupType.view),
    gallery("画廊", "spafont spa-icon-c-iconslist", ViewGroupType.view),
    form("表单", "spafont spa-icon-c-richeditor", ViewGroupType.view),
    foldingtree("folding树形", "spafont spa-icon-shukongjian", ViewGroupType.view),
    tree("数据树", "spafont spa-icon-c-shukongjian", ViewGroupType.view),
    navtree("导航树", "spafont spa-icon-shukongjian", ViewGroupType.nav),
    charts("统计图表", "xui-uicmd-location", ViewGroupType.charts),
    svg("SVG绘图", "spafont spa-icon-editpath", ViewGroupType.svg),
    module("内嵌模块", "spafont spa-icon-conf", ViewGroupType.module),
    dic("字典辅助", "spafont spa-icon-function", ViewGroupType.dic),
    domain("通用域", "spafont spa-icon-shukongjian", ViewGroupType.domain);


    private final String name;
    private final String imageClass;
    private ViewGroupType groupType;


    ViewType(String name, String imageClass, ViewGroupType groupType) {
        this.name = name;
        this.imageClass = imageClass;
        this.groupType = groupType;

    }

    public static ViewType fromType(String type) {
        ViewType defaultViewType = domain;
        if (type != null) {
            for (ViewType viewType : ViewType.values()) {
                if (viewType.getType().equals(type)) {
                    defaultViewType = viewType;
                }
            }
        }
        return defaultViewType;
    }

    public static Set<ViewType> getGroupView(ViewGroupType groupType) {
        Set<ViewType> viewTypes = new HashSet<>();
        if (groupType != null) {
            for (ViewType viewType : ViewType.values()) {
                if (viewType.getGroupType().equals(groupType)) {
                    viewTypes.add(viewType);
                }
            }
        }
        return viewTypes;
    }

    public ViewGroupType getGroupType() {
        return groupType;
    }

    public void setGroupType(ViewGroupType groupType) {
        this.groupType = groupType;
    }

    public String getImageClass() {
        return imageClass;
    }

    @Override
    public String toString() {
        return name();
    }

    @Override
    public String getType() {
        return name();
    }

    @Override
    public String getName() {
        return name;
    }
}
