package com.ds.web.annotation;

import com.ds.enums.IconEnumstype;

public enum RefType implements IconEnumstype {
    none("无", "spafont spa-icon-empty"),
    dic("字典", "spafont spa-icon-empty"),
    enums("枚举", "spafont spa-icon-empty"),
    ref("引用", "spafont spa-icon-c-databinder"),
    o2m("一对多", "spafont spa-icon-c-treeview"),
    m2o("多对一", "spafont spa-icon-alignwh"),
    f2f("自循环", "spafont spa-icon-cancel"),
    o2o("一对一", "spafont spa-icon-hmirror"),
    find("查找", "xui-icon-search"),
    m2m("多对多", "spafont spa-icon-alignwh");

    private final String imageClass;
    private final String name;

    RefType(String name, String imageClass) {
        this.name = name;
        this.imageClass = imageClass;
    }

    public String getImageClass() {
        return imageClass;
    }

    @Override
    public String toString() {
        return name();
    }

    @Override
    public String getType() {
        return name();
    }

    @Override
    public String getName() {
        return name;
    }
}
