package com.ds.web.annotation;

import com.ds.enums.BeanClass;
import com.ds.enums.db.EntityBean;

import java.lang.annotation.*;

@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
@BeanClass(clazz = EntityBean.class)
public @interface Entity {

    String repositoryId() default "default";

    Class sourceClass() default Void.class;

    Class serviceClass() default Void.class;

    Class rootClass() default Void.class;

}
