package com.ds.web.annotation;

import com.ds.enums.IconEnumstype;

public enum AggregationType implements IconEnumstype {
    aggregationRoot("聚合根", "spafont spa-icon-shukongjian"),
    aggregationSet("聚合关系", "spafont spa-icon-c-grid"),
    aggregationEntity("聚合实体", "spafont spa-icon-com"),
    menu("菜单", "spafont spa-icon-c-treebar"),
    customDomain("通用域服务", "spafont spa-icon-module"),
    view("视图", "spafont spa-icon-c-cssbox"),
    customapi("通用API", "spafont spa-icon-c-webapi");

    private final String name;
    private final String imageClass;


    AggregationType(String name, String imageClass) {
        this.name = name;
        this.imageClass = imageClass;
    }

    public static AggregationType fromType(String type) {
        AggregationType defaultViewType = aggregationRoot;
        if (type != null) {
            for (AggregationType viewType : AggregationType.values()) {
                if (viewType.getType().equals(type)) {
                    defaultViewType = viewType;
                }
            }
        }

        return defaultViewType;
    }

    public String getImageClass() {
        return imageClass;
    }

    @Override
    public String toString() {
        return name();
    }

    @Override
    public String getType() {
        return name();
    }

    @Override
    public String getName() {
        return name;
    }
}
