package com.ds.web;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.enums.db.MethodChinaName;
import com.ds.org.conf.OrgConstants;
import com.ds.web.util.AnnotationUtil;
import org.springframework.web.bind.annotation.RequestParam;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

public class ConstructorBean<T> {


    @JSONField(serialize = false)
    public Constructor constructor;
    public String name;
    public String className;
    public MethodChinaName methodChinaName;
    public Set<RequestParamBean> paramSet = new LinkedHashSet<>();
    public Map<String, Object> defaultParamsValueMap = new LinkedHashMap<String, Object>();
    public Set<String> requiredParams = new HashSet<>();
    public Map<String, String> paramsMap = new LinkedHashMap<String, String>();

    private static final Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), ConstructorBean.class);


    public ConstructorBean(Constructor<T> constructor) {
        this.constructor = constructor;
        this.className = constructor.getDeclaringClass().getName();
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        Class[] parameterClasses = constructor.getParameterTypes();
        String[] paramNames = new String[parameterTypes.length];
        Object[][] annotations = constructor.getParameterAnnotations();
        this.methodChinaName = AnnotationUtil.getConstructorAnnotation(constructor, MethodChinaName.class);
        Parameter[] parameters = constructor.getParameters();

        for (int i = 0; i < paramNames.length; i++) {
            String paramName = paramNames[i];
            Parameter parameter = parameters[i];
            if (paramName == null || paramName.equals("null") || paramName.equals("")) {
                if (parameters != null && parameters.length > i) {
                    paramName = parameters[i].getName();
                }
            }
            RequestParam paramAnnotation = parameter.getAnnotation(RequestParam.class);
            if (paramAnnotation != null) {
                if (!paramAnnotation.value().equals("")) {
                    paramName = paramAnnotation.value();
                }
                if (!paramAnnotation.defaultValue().equals("")) {
                    defaultParamsValueMap.put(paramName, paramAnnotation.defaultValue());
                }
                if (paramAnnotation.required()) {
                    requiredParams.add(paramName);
                }

            }
            Set<Annotation> annotationSet = new HashSet<>();
            for (Object annotationType : annotations[i]) {
                annotationSet.add((Annotation) annotationType);
            }
            RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i], parameterClasses[i]);
            paramSet.add(paramBean);
            paramsMap.put(paramName, parameterClasses[i].getName());
        }

    }

    Set<Class> getParamClassSet() {
        Set<Class> paramClassSet = new LinkedHashSet<>();
        for (RequestParamBean paramBean : paramSet) {
            paramClassSet.add(paramBean.getParamClass());
        }
        return paramClassSet;
    }


    @JSONField(serialize = false)
    public Constructor<T> getSourceConstructor() throws ClassNotFoundException {
        if (constructor == null) {
            Class clazz = ClassUtility.loadClass(this.getClassName());
            if (constructor == null) {
                for (Constructor innerconstructor : clazz.getConstructors()) {
                    if (innerconstructor.getParameterTypes().equals(getParamClassSet().toArray())) {
                        constructor = innerconstructor;
                    }
                }
            }
        }
        return constructor;
    }


    public Set<String> getRequiredParams() {
        return requiredParams;
    }

    public void setRequiredParams(Set<String> requiredParams) {
        this.requiredParams = requiredParams;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }


    public MethodChinaName getMethodChinaName() {
        return methodChinaName;
    }

    public void setMethodChinaName(MethodChinaName methodChinaName) {
        this.methodChinaName = methodChinaName;
    }


    public Set<RequestParamBean> getParamSet() {
        return paramSet;
    }

    public void setParamSet(Set<RequestParamBean> paramSet) {
        this.paramSet = paramSet;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParamsMap() {
        return paramsMap;
    }

    public void setParamsMap(Map<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }

}
